<?php echo $__env->make('wallet.include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.css">
<style>
    thead th {
        text-align: center;
    }
    .red_border{
        border-color: red !important;
    }
</style>

<div class="layout has-sidebar fixed-sidebar fixed-header">
    <?php echo $__env->make('wallet.include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div id="overlay" class="overlay"></div>
    <div class="layout">
        <main class="content">
            <div>
                <a id="btn-toggle" href="#" class="sidebar-toggler break-point-sm">
                    <i class="ri-menu-line ri-xl"></i>
                </a>
            </div>

            <div class="position-relative">
                <a href="#" class="nestcart-logo">
                    <img src="<?php echo e(asset('assets/services/images/logo.png')); ?>" alt="Logo" /> <span>NestCart</span>
                </a>

                <div class="logout-right position-absolute top-0 end-0">
                    <button class="logoutButton logoutButton--dark m-0">
                        <svg class="doorway" viewBox="0 0 100 100">
                            <path
                                d="M93.4 86.3H58.6c-1.9 0-3.4-1.5-3.4-3.4V17.1c0-1.9 1.5-3.4 3.4-3.4h34.8c1.9 0 3.4 1.5 3.4 3.4v65.8c0 1.9-1.5 3.4-3.4 3.4z" />
                            <path class="bang"
                                d="M40.5 43.7L26.6 31.4l-2.5 6.7zM41.9 50.4l-19.5-4-1.4 6.3zM40 57.4l-17.7 3.9 3.9 5.7z" />
                        </svg>
                        <svg class="figure" viewBox="0 0 100 100">
                            <circle cx="52.1" cy="32.4" r="6.4" />
                            <path
                                d="M50.7 62.8c-1.2 2.5-3.6 5-7.2 4-3.2-.9-4.9-3.5-4-7.8.7-3.4 3.1-13.8 4.1-15.8 1.7-3.4 1.6-4.6 7-3.7 4.3.7 4.6 2.5 4.3 5.4-.4 3.7-2.8 15.1-4.2 17.9z" />
                            <g class="arm1">
                                <path
                                    d="M55.5 56.5l-6-9.5c-1-1.5-.6-3.5.9-4.4 1.5-1 3.7-1.1 4.6.4l6.1 10c1 1.5.3 3.5-1.1 4.4-1.5.9-3.5.5-4.5-.9z" />
                                <path class="wrist1"
                                    d="M69.4 59.9L58.1 58c-1.7-.3-2.9-1.9-2.6-3.7.3-1.7 1.9-2.9 3.7-2.6l11.4 1.9c1.7.3 2.9 1.9 2.6 3.7-.4 1.7-2 2.9-3.8 2.6z" />
                            </g>
                            <g class="arm2">
                                <path
                                    d="M34.2 43.6L45 40.3c1.7-.6 3.5.3 4 2 .6 1.7-.3 4-2 4.5l-10.8 2.8c-1.7.6-3.5-.3-4-2-.6-1.6.3-3.4 2-4z" />
                                <path class="wrist2"
                                    d="M27.1 56.2L32 45.7c.7-1.6 2.6-2.3 4.2-1.6 1.6.7 2.3 2.6 1.6 4.2L33 58.8c-.7 1.6-2.6 2.3-4.2 1.6-1.7-.7-2.4-2.6-1.7-4.2z" />
                            </g>
                            <g class="leg1">
                                <path
                                    d="M52.1 73.2s-7-5.7-7.9-6.5c-.9-.9-1.2-3.5-.1-4.9 1.1-1.4 3.8-1.9 5.2-.9l7.9 7c1.4 1.1 1.7 3.5.7 4.9-1.1 1.4-4.4 1.5-5.8.4z" />
                                <path class="calf1"
                                    d="M52.6 84.4l-1-12.8c-.1-1.9 1.5-3.6 3.5-3.7 2-.1 3.7 1.4 3.8 3.4l1 12.8c.1 1.9-1.5 3.6-3.5 3.7-2 0-3.7-1.5-3.8-3.4z" />
                            </g>
                            <g class="leg2">
                                <path
                                    d="M37.8 72.7s1.3-10.2 1.6-11.4 2.4-2.8 4.1-2.6c1.7.2 3.6 2.3 3.4 4l-1.8 11.1c-.2 1.7-1.7 3.3-3.4 3.1-1.8-.2-4.1-2.4-3.9-4.2z" />
                                <path class="calf2"
                                    d="M29.5 82.3l9.6-10.9c1.3-1.4 3.6-1.5 5.1-.1 1.5 1.4.4 4.9-.9 6.3l-8.5 9.6c-1.3 1.4-3.6 1.5-5.1.1-1.4-1.3-1.5-3.5-.2-5z" />
                            </g>
                        </svg>
                        <svg class="door" viewBox="0 0 100 100">
                            <path
                                d="M93.4 86.3H58.6c-1.9 0-3.4-1.5-3.4-3.4V17.1c0-1.9 1.5-3.4 3.4-3.4h34.8c1.9 0 3.4 1.5 3.4 3.4v65.8c0 1.9-1.5 3.4-3.4 3.4z" />
                            <circle cx="66" cy="50" r="3.7" />
                        </svg>
                        <span class="button-text">Log Out</span>
                    </button>
                </div>

            </div>

            <div class="nestcart-table">
                <div class="card rounded-0 transparent-bg">
                    <div class="card-body p-lg-5">
                        <h5 class="mb-0 fw-bold">Create the following for your company :</h5>
                        <hr>
                        <form class="row g-3">
                            <div class="col-12">
                                <label class="form-label">Brand Name</label>
                                <input type="text" class="form-control" value="<?php 

                                    if(!empty($details))
                                    {
                                        echo $details['brand_name'];
                                    }

                                ?>" id="brand_name" placeholder="Brand Name" />
                            </div>
                            <div class="col-12">
                                <label class="form-label betweenflex">Slogan <a href="javascript:void(0)"
                                        class="btn btn-transparent rounded-pill" id="generateSlogan">Generate</a></label>
                                <textarea class="form-control" id="slogan" placeholder="Slogan"><?php if(!empty($details))
                                    {
                                        echo $details['slogan'];
                                    }?></textarea>
                            </div>
                            <div class="col-12 betweenflex">
                                <div class="input-group custom-file-button">
                                    <label class="input-group-text">Choose Logo</label>
                                    <input type="file" id="logo" class="form-control" />
                                </div>
                                <a href="#" class="btn btn-transparent rounded-pill ms-3">Generate</a>
                            </div>
                            <div class="col-12">
                                <div class="input-group custom-file-button">
                                    <label class="input-group-text">Choose Favicon</label>
                                    <input type="file" id="favicon" class="form-control" />
                                </div>
                            </div>
                            <div class="col-12">
                                <label class="form-label">Company Name</label>
                                <input type="text" id="company_name" class="form-control" value="<?php 

                                if(!empty($details))
                                {
                                    echo $details['company_name'];
                                }

                            ?>" placeholder="Company Name" />
                            </div>
                            <div class="col-12">
                                <label class="form-label">Address</label>
                                <textarea class="form-control" id="address" placeholder="Address"><?php 

                                    if(!empty($details))
                                    {
                                        echo $details['address'];
                                    }

                                ?></textarea>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Business Category</label>
                                <select class="form-control form-select" id="businessCategory">
                                    <option value="">Choose...</option>
                                    <?php $__currentLoopData = $project_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php 

                                    if(!empty($details))
                                    {
                                        if($details['category'] == $category->slug)
                                        {
                                            echo "selected";
                                        }
                                    }

                                ?> value="<?php echo e($category->slug); ?>">
                                        <?php echo e($category->category); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Services</label>
                                <input type="text" value="<?php 

                                if(!empty($details))
                                {
                                    echo $details['company_services'];
                                }

                            ?>" class="form-control" id="service" placeholder="Services Name" />
                            </div>
                            <div class="col-12 text-end">
                                <a href="#" class="btn btn-transparent" id="saveProject">Save</a>
                                <a href="javascript:void(0)" id="closeForm" class="btn btn-transparent">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </main>
        <div class="overlay"></div>
    </div>
</div>

<input type="hidden" name="" id="lat">
<input type="hidden" name="" id="long">

<?php echo $__env->make('wallet.include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.js"></script>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDlFzdbBe7bMPm9jrCo6C8340ELKtsZjEw&libraries=places"></script>
<script>

initAutocomplete();

function initAutocomplete() {
    const input = document.getElementById('address');
    const autocomplete = new google.maps.places.Autocomplete(input);
    autocomplete.setTypes(['geocode']); 
    autocomplete.addListener('place_changed', function() {
        const place = autocomplete.getPlace();
        if (place.geometry) {
            const addressComponents = place.address_components;
            const countryComponent = addressComponents.find(component => 
                component.types.includes('country')
            );
            if (countryComponent) {
                const countryCode = countryComponent.short_name.toLowerCase();
            }
            const latitude = place.geometry.location.lat();
            const longitude = place.geometry.location.lng();
            $("#lat").val(latitude);
            $("#long").val(longitude);

        }
    });
}

</script>
<script>
    $("#generateSlogan").on('click', function(){
        var brandName = $("#brand_name").val();
        if(!brandName)
        {
            $("#brand_name").addClass('red_border');
            $("#brand_name").focus();
            generalError("Please fill in all required fields to generate slogan");
            return;   
        }

        var category = $("#businessCategory").val();
        if(!category || category == "")
        {
            $("#businessCategory").focus();
            $("#businessCategory").addClass('red_border');
            generalError("Please fill in all required fields to generate slogan");
            return;
        }

        var url = "<?php echo e(route('ai.generate.content')); ?>";
        var content = 'Generate a slogan, my brand name is '+brandName+' and category is '+category + " and return in json";
        var data = {content:content, _token:'<?=csrf_token(); ?>'}
        var btn = $(this);
        var btn_html = btn.html();
        btn.html("<i class='fa fa-spinner fa-spin'></i>");
        $.post(url, data, function(data){
            btn.html(btn_html);
            if(!data.result)
            {
                if(data.msg)
                {
                    generalError(data.msg)
                    return;   
                }

                generalError("Some error occured");
                return;
            }

            var slogan = data.slogan;
            $("#slogan").val(slogan);

        });


    });

    $(".form-control").on('input', function(){
        $(".form-control").removeClass('red_border');
    })

    $(".form-control").on('change', function(){
        $(".form-control").removeClass('red_border');
    })

    function generalError(msg)
    {
        $.confirm({
            title:"Error",
            content:msg,
            icon:"fa fa-times-circle",
            type:"red",
            buttons: {
                confirm: {
                    text: 'OK',
                    btnClass: 'btn-red',
                    action: function() {
                    }
                }
            }
        });
    }

</script>
<script>
    $("#closeForm").on('click', function(){
        var url = '<?php echo e(url('subscriptions')); ?>';
        location.href = url;
    })
</script>
<script>
    $("#saveProject").on('click', function(){
        var brandName = $("#brand_name").val();
        if(!brandName)
        {
            $("#brand_name").addClass('red_border');
            generalError("Please fill in all required fields");
            return;   
        }
        var slogan = $("#slogan").val();
        if(!slogan)
        {
            $("#slogan").addClass('red_border');
            generalError("Please fill in all required fields");
            return;
        }
        var logo = $('#logo')[0].files[0];
        var favIcon = $('#favicon')[0].files[0];

        
        var getDetails = '<?=json_encode($details); ?>';
        var projectAlreadyExsist = true;
        
        if(getDetails)
        {
            getDetails = JSON.parse(getDetails);
            if (Object.keys(getDetails).length === 0) {
                projectAlreadyExsist = false;
                if(!logo)
                {
                    generalError("Please upload a logo");
                    $("#logo").addClass('red_border');
                    return;
                }

                if(!favIcon)
                {
                    generalError("Please upload a favicon");
                    $("#favicon").addClass('red_border');
                    return;
                }
            }
        }

        var companyName = $("#company_name").val();
        if(!companyName)
        {
            generalError("Please enter company name");
            $("#company_name").addClass('red_border');
            return;
        }

        var companyAddress = $("#address").val();
        if(!companyAddress)
        {
            generalError("Please enter company address");
            $("#address").addClass('red_border');
            return;
        }

        var service = $("#service").val();
        if(!service)
        {
            generalError("Please enter service for your brand");
            $("#service").addClass('red_border');
            return;
        }
        var category = $("#businessCategory").val();
        if(!category || category == "")
        {
            generalError("Please select business category");
            $("#businessCategory").addClass('red_border');
            return;
        }

        var lat = $("#lat").val();
        var lon = $("#long").val();

        var form = new FormData();
        form.append('brand_name', brandName);
        form.append('slogan', slogan);
        form.append('company_name', companyName);
        form.append('company_address', companyAddress);
        form.append('logo', logo);
        form.append('favicon', favIcon);
        form.append('service', service);
        form.append('_token', '<?=csrf_token(); ?>');
        form.append('subscription_id', "<?php echo e($subscription_id); ?>");
        form.append('lattitude', lat);
        form.append('longitude', lon);
        form.append('category', category);

        var btn = $(this);
        var btn_html = btn.html();
        btn.html("<i class='fa fa-spinner fa-spin'></i>");
        var url = "<?php echo e(route('ai.project.website.update_details')); ?>";
        $.ajax({
            url: url,
            type: 'POST',
            data: form,
            processData: false,
            contentType: false,
            success: function(data) {
                btn.html(btn_html);
                if(!data.result)
                {
                    generalError(data.msg);
                    return;   
                }
                

                $.confirm({
                    title:"Success",
                    content:"Project Detail Updated Successfully",
                    icon:"fa fa-check-circle",
                    type:"green",
                    buttons: {
                        confirm: {
                            text: 'OK',
                            btnClass: 'btn-red',
                            action: function() {

                                if(!projectAlreadyExsist)
                                {
                                    var url = "<?php echo e(url('ai/website/edit/')); ?>" + "/" + data.id;
                                    location.href = url;    
                                }

                                
                            }
                        }
                    }
                });
                
            },
            error: function(xhr) {
                btn.html(btn_html);
                generalError("Some error occured")
            }
        });



    });
</script><?php /**PATH D:\aflisocial\resources\views/projects/website/details.blade.php ENDPATH**/ ?>