
<?php $__env->startSection('css'); ?>
    <style>
        .start_purchase {
            padding-top: 20px;
            padding-bottom: 20px;
        }

        .fa {
            padding: 0px !important;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="pricing-section py-5">
        <div class="container">

            <div class="wrap mb-4">
                <div class="">
                    <h1 class="main__heading mb-0 me-3 text-dark fw-bold">Pricing For <span
                            class="bg-primary text-white px-3 py-1" style="border-radius: 5px;">Ecommerce</span></h1>
                </div>
            </div>
            <span class="switch">
                <label class="h4 me-2 text-dark fw-bold">Monthly</label>
                <input type="checkbox" class="switch" id="switch-id" />
                <label class="h4 text-dark fw-bold" for="switch-id">Annually</label>
            </span>

            <div class="">
                <div class="main__cards cards">
                    <div class="cards__inner">

                        <?php if(!$packages->isEmpty()): ?>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="cards__card card monthly">
                                    <h2 class="card__heading"><?php echo e($package->name); ?></h2>
                                    <p class="card__price" data-monthly="<?php echo e($package->price); ?>"
                                        data-annual="<?php echo e($package->price * 12); ?>">
                                        <?php echo e(currency_symbol()); ?><?php echo e($package->price); ?>

                                    </p>
                                    <ul role="list" class="card__bullets flow">

                                        <?php
                                            $features = json_decode($package->features);
                                        ?>

                                        <?php if(!empty($features)): ?>
                                            <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <?php echo e($feature); ?>

                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <?php echo e($package->emails); ?> Professional Emails
                                            </li>
                                        <?php endif; ?>


                                    </ul>
                                    <a href="javascript:void(0)" class="card__cta cta start_purchase"
                                        data-price="<?php echo e($package->price); ?>" data-id="<?php echo e($package->id); ?>">Get Started</a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                    <div class="overlay cards__inner"></div>
                </div>
            </div><!-- Monthly -->


        </div><!-- container -->
    </section><!-- pricing-section -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        $('.dropdown-menu a').click(function() {
            $('#selected').text($(this).text());
        });
    </script>
    <script>
        $(document).on('click', '.buy_now', function() {
            var id = $(this).attr('data-id');

            var wallet = '<?= $wallet ?>';
            var price = $(this).attr('data-price');
            wallet = parseFloat(wallet);
            price = parseFloat(price);
            if (price > wallet) {
                rechargeError("Insufficient balance");
                return;
            }

            $.confirm({
                title: "Confirm Purchase",
                content: "Are you sure you want to purchase this package",
                icon: "fa fa-exclamation-triangle",
                type: "orange",
                buttons: {
                    recharge: {
                        text: 'Activate',
                        btnClass: 'btn-green',
                        action: function() {

                            var data = {
                                package_id: id,
                                _token: "<?php echo e(csrf_token()); ?>"
                            };
                            var url = '<?= url('user/subscriptions/activate') ?>';
                            $.post(url, data, function(data) {
                                console.log(data);
                                if (data.result && data) {
                                    $.confirm({
                                        title: "Package Activated",
                                        content: "Package Activated Successfully",
                                        icon: "fa fa-check-circle",
                                        type: "green",
                                        buttons: {
                                            confirm: {
                                                text: 'OK',
                                                btnClass: 'btn-red',
                                                action: function() {
                                                    location.href =
                                                        '<?= url('subscriptions') ?>'
                                                }
                                            }
                                        }
                                    });
                                } else {

                                    generalError("Some error occured")

                                }
                            }).fail(function() {
                                generalError("Some error occured")
                            })

                        }
                    },
                    confirm: {
                        text: 'Later',
                        btnClass: 'btn-red',
                        action: function() {}
                    }

                }
            })

        })

        function generalError(msg) {
            $.confirm({
                title: "Error",
                content: msg,
                icon: "fa fa-times-circle",
                type: "red",
                buttons: {
                    confirm: {
                        text: 'OK',
                        btnClass: 'btn-red',
                        action: function() {}
                    }
                }
            });
        }

        function rechargeError(msg) {
            $.confirm({
                title: 'Error!',
                content: msg,
                icon: 'fa fa-times-circle', // Green check icon
                type: 'red', // Green color for the icon
                buttons: {
                    recharge: {
                        text: 'Recharge Your Account',
                        btnClass: 'btn-green',
                        action: function() {
                            location.href = '<?= url('wallet/add') ?>'
                        }
                    },
                    confirm: {
                        text: 'OK',
                        btnClass: 'btn-red',
                        action: function() {}
                    }

                }
            });
        }
    </script>
    <script>
        $(document).on('click', '.start_purchase', function() {
            var id = $(this).attr('data-id');
            var url = "<?php echo e(route('ai.ecommerce.purchase.start')); ?>";
            var btn = $(this);
            var btn_html = btn.html();
            btn.html("<i class='fa fa-spinner fa-spin'></i>");
            var data = {
                _token: "<?php echo e(csrf_token()); ?>",
                id: id
            };
            $.ajax({
                url: url,
                type: "POST",
                data: data,
                dataType: "json",
                success: function(data) {
                    btn.html(btn_html);

                    if (!data.result) {
                        generalError(data.msg ?? "Some error occurred");
                        return;
                    }
                    location.href = "<?php echo e(route('ai.ecommerce.purchase.step1')); ?>";
                },
                error: function(xhr) {
                    btn.html(btn_html);
                    if (xhr.status === 401) {
                        // ✅ Not logged in – go to login page
                        window.location.href = "<?php echo e(route('login')); ?>";
                    } else {
                        generalError(xhr.responseText ?? "Some error occured");
                    }
                }
            });
        });
    </script>
    <script>
        $('#switch-id').on('change', function() {
            var currencySymbol = "<?php echo e(currency_symbol()); ?>";

            $(".card__price").each(function() {
                var monthly = parseFloat($(this).data('monthly'));
                var annual = parseFloat($(this).data('annual'));

                if ($('#switch-id').is(':checked')) {

                    $(this).html(currencySymbol + " " + annual.toFixed(2));
                } else {
                    $(this).html(currencySymbol + " " + monthly.toFixed(2));
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ecommerce.purchase.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\aflisocial\resources\views/ecommerce/purchase/buy.blade.php ENDPATH**/ ?>