<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
       $schedule->command('purchase_ecommerce_domain')
        ->everyTenMinutes()
        ->before(function () {
            \Log::info('purchase_ecommerce_domain started');
        })
        ->after(function () {
            \Log::info('purchase_ecommerce_domain finished');
        });

         $schedule->command('upload_personal_files')
            ->everyFiveMinutes();

        $schedule->command('purchase_domain')
        ->everyTenMinutes()
        ->before(function () {
            \Log::info('Purchasing Personal Domain started');
        })
        ->after(function () {
            \Log::info('Purchasing Personal Domain finished');
        });

        $schedule->command('update_personal_domain_dns')->everyMinute();
        $schedule->command('check_ecommerce_propogation')
            ->everyMinute()
            ->after(function () {
                \Log::info('check_ecommerce_propogation ran');
            });

        $schedule->command('connect_ecommerce_domain')
            ->everyMinute()
            ->after(function () {
                \Log::info('connect_ecommerce_domain ran');
            });
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
