<?php 

use App\Models\Ecommerce\UserEcommerceSubscriptions;
use App\Models\Domain;
use App\Models\Ecommerce\EcommerceProjects;
use Illuminate\Support\Facades\Storage;

if (!function_exists('project_detail')) {
    function project_detail($id)
    {
        $project_detail = EcommerceProjects::where('ecommerce_subscription_id', $id)->first();

        if (!$project_detail) {
            return [
                'logo'  => asset('assets/services/images/logo.png'),
                'brand' => 'Afli',
            ];
        }

        return [
            'logo'  => $project_detail->logo
                        ? asset(\Storage::url($project_detail->logo))
                        : asset('assets/services/images/logo.png'),
            'brand' => $project_detail->brand_name ?? 'Afli',
        ];
    }
}


if (!function_exists('CheckEcommerceSubscriptions')) {

    function CheckEcommerceSubscriptions($subscriptionId)
    {
        $subscriptionDetails = UserEcommerceSubscriptions::where('id', $subscriptionId)->first();
        if(empty($subscriptionDetails))
        {
            return ['result'=>false, 'error'=>'Subscription not found'];
        }
        if(empty($subscriptionDetails->domain))
        {
            return ['result'=>false, 'error'=>'Domain not added yet'];
        }

        
        
        
        return [
            'domain'=>$subscriptionDetails->domain,
            'status'=>$subscriptionDetails->domain_status,
            'result'=>true
        ];

    }

}