<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Ecommerce\Subcategory;
use App\Models\Ecommerce\Categories;

class SubCategoriesController extends Controller
{
    public function get(Request $request)
    {
        $user_id = $request->api_user_id;
        if(!$request->has('category_id'))
        {
            return response()->json(['result'=>false, 'error'=>'Please specify category id'], 422);
        }

        $category_id = $request->category_id;
        $checkCategory = Categories::where('id', $category_id)->first();
        if(empty($checkCategory))
        {
            return response()->json(['result'=>false, 'error'=>'Category not found'], 422);
        }

        if($checkCategory->user_id != $user_id)
        {
            return response()->json(['result'=>false, 'error'=>'You are not authorized to view this category'], 422);
        }

        $subCategories = Subcategory::where('category_id', $checkCategory->id)->get();
        if($subCategories->isEmpty())
        {
            return response()->json(['result'=>false, 'error'=>'No Sub Category Found'], 200);
        }

        return response()->json(['result'=>true, 'sub_categories'=>$subCategories], 200);

    }
}
