<?php

namespace App\Http\Controllers;


require __DIR__.'/OAuth.php';
use Illuminate\Http\Request;
use OAuthConsumer;
use OAuthRequest;
use OAuthSignatureMethod_HMAC_SHA1;
use OAuthUtil;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Http;
use Illuminate\Support\Facades\Storage;
use Auth;
use DB;

class LogoController extends Controller
{
   

    public function index()
    {
        $data['sidebar'] = 'dashboard';
        return view('logos.index', $data);
    }

    public function generate()
    {
        $data['sidebar'] = 'generate';
        return view('logos.generate', $data);
    }

    public function searchIcon(Request $request)
    {
        $query = $request->icon;
        $icons = $this->getIcons($query);
        $icons = json_decode($icons, true);
        if(empty($icons['icons']))
        {
            return response()->json(['result'=>false, 'msg'=>'Icons not found']);
        }

        $icons = $icons['icons'];

        return response()->json(['result'=>true, 'icons'=>$icons]);

    }

    public function searchIcons(Request $request)
    {
        $limit = 50;
        if($request->has('limit'))
        {
            $limit = $request->limit;
        }

        $searchQuery = "Random";
        if($request->has('search'))
        {
            $searchQuery = $request->search;
        }

        $cc_key  = "fffc27f0acd44d6f8733a9b7dd25f468";
        $cc_secret = "097a938519344899baa48fc92fabf74f";
        $url = "https://api.thenounproject.com/v2/icon";
        $args = [];
        $args["query"] = $searchQuery;
        $args["limit"] = $limit;
        $args['limit_to_public_domain'] = 1;
        $args['thumbnail_size'] = 42;
        $args['include_svg'] = 1;

        $consumer = new OAuthConsumer($cc_key, $cc_secret);
        $request = OAuthRequest::from_consumer_and_token($consumer, NULL,"GET", $url, $args);
        $request->sign_request(new OAuthSignatureMethod_HMAC_SHA1(), $consumer, NULL);
        $url = sprintf("%s?%s", $url, OAuthUtil::build_http_query($args));
        
        $ch = curl_init();
        $headers = array($request->to_header());
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        $rsp = curl_exec($ch);
        return response()->json($rsp);

    }

    public function getIcons($search)
    {
        $cc_key  = "fffc27f0acd44d6f8733a9b7dd25f468";
        $cc_secret = "097a938519344899baa48fc92fabf74f";
        $url = "https://api.thenounproject.com/v2/icon";
        $args = array();
        $args["query"] = $search;
        $args["limit"] = 50;
        $args['limit_to_public_domain'] = 1;
        $args['thumbnail_size'] = 42;
        $args['include_svg'] = 1;

        $consumer = new OAuthConsumer($cc_key, $cc_secret);
        $request = OAuthRequest::from_consumer_and_token($consumer, NULL,"GET", $url, $args);
        $request->sign_request(new OAuthSignatureMethod_HMAC_SHA1(), $consumer, NULL);
        $url = sprintf("%s?%s", $url, OAuthUtil::build_http_query($args));
        $ch = curl_init();
        $headers = array($request->to_header());
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        $rsp = curl_exec($ch);
        return $rsp;
    
    }

    public function downloadIcon(Request $request)
    {
        $url = $request->url;
        $content = file_get_contents($url);
        return response()->json(['image'=>$content]);
    }

    public function saveLogoFile(Request $request)
    {
         $request->validate([
            'image' => 'required|string',
            'brandName'=>'required',
            'businessType'=>'required'
        ]);

        $imageData = $request->input('image');
        $brandName = $request->input('brandName');
        $businessType = $request->input('businessType');
        $image = str_replace('data:image/png;base64,', '', $imageData);
        $image = str_replace(' ', '+', $image);
        $fileName = 'logo_' . time() . '.png';
        Storage::disk('public')->put('generated_logos/' . $fileName, base64_decode($image));

        DB::table('logos')->insert([
            'logo'=>'generated_logos/'.$fileName,
            'user_id'=>Auth::user()->id,
            'logo_name'=>$brandName,
            'company_type'=>$businessType,
            'created_at'=>now(),
            'updated_at'=>now()
        ]);

        return response()->json(['message' => 'Image saved successfully', 'file_path' => 'logos/' . $fileName], 200);


    }

    public function dashboard(Request $request)
    {
        $logos = DB::table('logos')->where('user_id', Auth::user()->id)->get();
        return view('logos.dashboard', compact('logos'));
    }

}
