<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Stripe\Stripe;
use Stripe\PaymentIntent;
use App\Models\Transactions;
use Auth;
use Illuminate\Support\Facades\Session;
use App\Models\Subscriptions;
use App\Models\Currencies;

class WalletController extends Controller
{
    public function index()
    {
        $data = [];
        $data['transactions'] = Transactions::where('user_id', Auth::user()->id)->orderBy('id', 'desc')->paginate(10);
        return view('wallet.index', $data);
    }

    public function add(Request $request)
    {
        $data = [];
        $stripePublicKey = env('STRIPE_PUBLIC_KEY');
        $stripePrivateKey = env('STRIPE_PRIVATE_KEY');
        $data['stripe_public_key'] = $stripePublicKey;
        $data['stripe_private_key'] = $stripePrivateKey;
        return view('wallet.add', $data);
    }

    public function createSubscriptionPaymentIntent(Request $request)
    {
        $stripePrivateKey = env('STRIPE_PRIVATE_KEY');
        Stripe::setApiKey($stripePrivateKey);

        $subscriptionId = Session::get('purchase_subscription');
        $domainDetails = Session::get('domain');

        if(!$subscriptionId)
        {
            return response()->json(['result'=>false, 'msg'=>'Subscription not found']);
        }

        

        $subscription = Subscriptions::where('id', $subscriptionId)->first();
        if(empty($subscription))
        {
            return response()->json(['result'=>false, 'msg'=>'You dont have any selected subscription']);
        }

        $totalPrice = $subscription->price;
        
        if(Session::has('domain'))
        {
            $domainDetails = json_decode($domainDetails, true);

            if(!empty($domainDetails) && is_array($domainDetails))
            {
                if(isset($domainDetails['price']))
                {
                    $totalPrice += $domainDetails['price'];
                }
            }
        }
        
        $activeCurrency = Currencies::where('status', 'active')->first();
        $active ="usd";
        if(!empty($activeCurrency))
        {
            $active =$activeCurrency->iso;
            $active = strtolower($active);
        }

        if(!$active)
        {
            $active = "usd";
        }

        $totalPrice = intval(round($totalPrice));

        
        try {
            $paymentIntent = PaymentIntent::create([
                'amount' => $totalPrice * 100, // Amount in cents
                'currency' => $active,
                'payment_method_types' => ['card'], // Specify payment method types
            ]);

            return response()->json([
                'clientSecret' => $paymentIntent->client_secret,
                'result'=>true
            ]);
        } catch (\Exception $e) {
            return response()->json(['msg' => $e->getMessage(), 'result'=>false]);
        }



    }


    public function createStripePaymentIntent(Request $request)
    {
        $amount = $request->amount;
        $stripePrivateKey = env('STRIPE_PRIVATE_KEY');
        Stripe::setApiKey($stripePrivateKey);
        try {
            $paymentIntent = PaymentIntent::create([
                'amount' => $request->amount * 100, // Amount in cents
                'currency' => 'usd',
                'payment_method_types' => ['card'], // Specify payment method types
            ]);

            return response()->json([
                'clientSecret' => $paymentIntent->client_secret,
                'result'=>true
            ]);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage(), 'result'=>false], 500);
        }
    }

}
