<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class RoleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string  $role
     * @return mixed
     */
    public function handle($request, Closure $next, ...$roles)
    {
        // Support comma-separated role like role:1,2 passed as a single string
        if (count($roles) === 1 && is_string($roles[0]) && str_contains($roles[0], ',')) {
            $roles = array_map('trim', explode(',', $roles[0]));
        }

        if (Auth::check()) {
            $userRole = (string) Auth::user()->role;
            if (empty($roles) || in_array($userRole, array_map('strval', $roles), true)) {
                return $next($request);
            }
        }
        return redirect()->route('dashboard')->with('error', 'You do not have access to this page');
    }
}
