<?php

namespace App\Models\Cgi;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Cgi\CgiVideoTemplates;
use App\Models\User;
use App\Models\Transactions;

class CgiOrders extends Model
{
    use HasFactory;

    protected $table = 'cgi_orders';

    protected $fillable = [
        'order_id',
        'user_id',
        'cgi_template',
        'image',
        'status',
        'generated_video',
        'transaction_id',
        'modal_data'
    ];

    public function templates()
    {
        return $this->belongsTo(CgiVideoTemplates::class, 'cgi_template');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function transaction()
    {
        return $this->belongsTo(Transactions::class, 'transaction_id');
    }


}
