<?php

namespace App\Models\Ecommerce;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\EcommerceSubscriptions;
use App\Models\Ecommerce\EcommerceProjects;
use App\Models\Cpanels;

class UserEcommerceSubscriptions extends Model
{
    use HasFactory;

    protected $table = 'user_ecommerce_subscriptions';
    protected $fillable = [
        'subscription_id',
        'user_id',
        'activated_on',
        'expires_on',
        'price',
        'transaction_id',
        'domain',
        'domain_api',
        'domain_price',
        'domain_status',
        'cpanel_id'
    ];

    public function cpanel()
    {
        return $this->belongsTo(Cpanels::class, 'cpanel_id');
    }

    public function project_detail()
    {
        return $this->hasOne(EcommerceProjects::class, 'ecommerce_subscription_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function package()
    {
        return $this->belongsTo(EcommerceSubscriptions::class, 'subscription_id');
    }


}
