<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    public $table = "packages";

    protected $fillable = [
        'title',
        'slug',
        'price',
        'package_type',
        'term',
        'featured',
        'all_features',
        'is_trial',
        'trial_days',
        'status',
        'features',
        'meta_keywords',
        'meta_description',
    ];

    public function memberships() {
        return $this->hasMany('App\Models\Membership');
    }
}
