<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\UserSubscriptions;

class Projects extends Model
{
    use HasFactory;
    protected $table = "projects";
    protected $fillable = [
        'uid',
        'name',
        'user_subscription_id',
        'company_name',
        'brand_name',
        'company_email',
        'company_phonenumber',
        'company_facebook',
        'company_twitter',
        'company_linkedin',
        'company_services',
        'company_logo',
        'favicon',
        'slogan',
        'category',
        'address',
        'latitude',
        'longitude',
        'country',
        'iso2',
        'ai_generated',
        'status',
        'theme'

    ];

    /**
     * Get the user that owns the Projects
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function subscription()
    {
        return $this->belongsTo(UserSubscriptions::class, 'user_subscription_id');
    }
}
