<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Transactions;
use App\Models\Subscriptions;
use App\Models\Cpanels;
use App\Models\Domain;

class UserSubscriptions extends Model
{
    use HasFactory;

    protected $table = 'user_subscriptions';

    protected $fillable = [
        'subscription_id',
        'user_id',
        'activated_on',
        'expires_on',
        'active_projects',
        'total_projects',
        'price',
        'transaction_id',
        'cpanel_id',
        'domain',
        'domain_price',
        'domain_status',
        'domain_api'
    ];

    protected $appends = ['domain_status_info'];

    // Relationships
    public function transaction()
    {
        return $this->belongsTo(Transactions::class, 'transaction_id');
    }

    public function package()
    {
        return $this->belongsTo(Subscriptions::class, 'subscription_id');
    }

    public function cpanel()
    {
        return $this->belongsTo(Cpanels::class, 'cpanel_id');
    }

    public function domainRecord()
    {
        return $this->hasOne(Domain::class, 'user_subscription_id', 'id');
    }

    // Helper method
    public function getDomainStatusInfo(): array
    {
        return match ($this->domain_status) {
            'pending'     => ['label' => 'Purchase Pending',       'class' => 'bg-warning'],
            'active'      => ['label' => 'Domain Active',  'class' => 'bg-success'],
            'inactive'    => ['label' => 'Inactive',       'class' => 'bg-danger'],
            'propagation' => ['label' => 'Propagating...', 'class' => 'bg-info'],
            'expired'     => ['label' => 'Expired',        'class' => 'bg-danger'],
            'others'      => ['label' => 'Unknown',        'class' => 'bg-dark'],
            default       => ['label' => 'Unknown',        'class' => 'bg-dark'],
        };
    }

    // ✅ Accessor to enable `$model->domain_status_info`
    public function getDomainStatusInfoAttribute(): array
    {
        return $this->getDomainStatusInfo();
    }
}
