<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::create('link_visitors', function (Blueprint $table) {
            $table->id();
            $table->foreignId('short_link_id')->constrained('short_links')->onDelete('cascade'); // Link to the short link
            $table->string('ip_address'); // IP address of the visitor
            $table->text('user_agent'); // User agent of the visitor (browser/device info)
            $table->timestamps(); // Track created_at and updated_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('link_visitors');
    }
};
