<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id(); // Auto-incrementing primary key
            $table->unsignedBigInteger('user_id'); // User ID who made the transaction
            $table->string('transaction_id')->unique();
            $table->decimal('amount', 10, 2); // The amount of the transaction
            $table->string('transaction_type'); // Type of transaction (e.g., 'deposit', 'withdrawal', etc.)
            $table->string('status'); // Status of the transaction (e.g., 'completed', 'pending', 'failed')
            $table->text('description')->nullable();
            $table->timestamps();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
