<?php 

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserSubscriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_subscriptions', function (Blueprint $table) {
            $table->id(); // auto-incrementing primary key
            $table->unsignedBigInteger('subscription_id'); // foreign key to subscriptions table
            $table->unsignedBigInteger('user_id'); // foreign key to users table
            $table->dateTime('activated_on'); // when the subscription is activated
            $table->dateTime('expires_on'); // when the subscription expires
            $table->integer('active_projects'); // number of active projects
            $table->integer('total_projects'); // total number of projects
            $table->decimal('price', 10, 2); // subscription price
            $table->integer('transaction_id')->nullable(); // transaction ID, nullable
            $table->timestamps(); // created_at and updated_at timestamps

            $table->index('subscription_id'); // Create index for subscription_id
            $table->index('user_id'); // Create index for user_id

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('subscription_id')->references('id')->on('subscriptions')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_subscriptions');
    }
}
