<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100);
            $table->unsignedBigInteger('uid'); // Foreign key to users table
            $table->unsignedBigInteger('user_subscription_id'); // Foreign key to user_subscriptions table
            $table->string('company_name', 255)->nullable();
            $table->string('company_email', 255)->nullable();
            $table->string('company_phonenumber', 255)->nullable();
            $table->string('company_facebook', 255)->nullable();
            $table->string('company_twitter', 255)->nullable();
            $table->string('company_linkedin', 255)->nullable();
            $table->string('company_services', 255)->nullable();
            $table->string('company_logo', 255)->nullable();
            $table->string('favicon', 255)->nullable();
            $table->string('slogan', 255)->nullable();
            $table->string('category', 255)->nullable();
            $table->string('address', 255)->nullable();
            $table->string('latitude', 255)->nullable();
            $table->string('longitude', 255)->nullable();
            $table->string('country', 255)->nullable();
            $table->string('iso2', 255)->nullable();
            $table->integer('ai_generated')->default(0);
            $table->integer('status')->default(0);

            // Add foreign key constraints
            $table->foreign('uid')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('user_subscription_id')->references('id')->on('user_subscriptions')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};
