<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('domains', function (Blueprint $table) {
            if (!Schema::hasColumn('domains', 'user_subscription_id')) {
                $table->unsignedBigInteger('user_subscription_id')->nullable();
            } else {
                $table->unsignedBigInteger('user_subscription_id')->nullable()->change();
            }
            $table->foreign('user_subscription_id')
                ->references('id')
                ->on('user_subscriptions')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('domains', function (Blueprint $table) {
            // Drop the foreign key constraint
            if (Schema::hasColumn('domains', 'user_subscription_id')) {
                $table->dropForeign(['user_subscription_id']);
                $table->dropColumn('user_subscription_id');
            }
        });
    }
};
