<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sub_categories', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->unsignedBigInteger('category_id'); 
            $table->unsignedBigInteger('user_id'); 
            $table->string('name'); // Name of the subcategory
            $table->string('slug')->unique();
            $table->text('description')->nullable(); // Description of the subcategory (optional)
            $table->string('image')->nullable(); // Path to the image (optional)
            $table->boolean('is_active')->default(true); // Active status
            $table->timestamps();
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sub_categories');
    }
};
