<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->string('short_description');
            $table->longText('description');
            $table->decimal('price', 10, 2);
            $table->decimal('discount_price', 10, 2)->nullable();
            $table->decimal('shipping_price', 10, 2)->nullable();
            $table->integer('quantity')->default(0); // Stock quantity
            $table->string('sku')->nullable();
            $table->foreignId('category_id')
                ->constrained('categories', 'id') 
                ->onDelete('cascade'); 
            $table->foreignId('subcategory_id')
            ->nullable()
            ->constrained('sub_categories', 'id') // Links to sub_categories.id
            ->onDelete('set null');
            $table->foreignId('brand_id')
                ->nullable()
                ->constrained('brands', 'id') 
                ->onDelete('set null'); 
            $table->foreignId('user_id')
                ->constrained('users', 'id')
                ->onDelete('cascade');
            $table->json('gallery')->nullable();
            $table->json('variations')->nullable();
            $table->boolean('is_active')->default(true); 
            $table->boolean('is_featured')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
