<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ftp_accounts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('cpanel_id');
            $table->string('ftp_username');
            $table->string('ftp_password');
            $table->enum('status', ['assigned', 'not_assigned'])->default('not_assigned');
            $table->foreign('cpanel_id')->references('id')->on('cpanel')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
          Schema::dropIfExists('ftp_accounts');
    }
};
