<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sqldatabase', function (Blueprint $table) {
            $table->id();
            $table->string('db_user');
            $table->string('db_password');
            $table->string('db_name');
            $table->unsignedBigInteger('cpanel_id');
            $table->foreign('cpanel_id')->references('id')->on('cpanel')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sqldatabase');
    }
};
