<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scheduled_emails', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->unsignedBigInteger('mailbox_id');
            $table->string('subject'); // Email subject
            $table->timestamp('scheduled_at'); // Time to send the email
            $table->unsignedBigInteger('staff_id'); 
            $table->string('from_email')->nullable(); 
            $table->string('from_name')->nullable(); // Sender name
            $table->string('to_email')->nullable(); // Recipient email address
            $table->enum('direction', ['inbound', 'outbound'])->default('inbound'); // Email direction
            $table->text('message')->nullable(); // Email body
            $table->string('label')->nullable(); // Email label (if any)
            $table->string('email_id')->nullable(); // Unique email identifier
            $table->timestamp('email_date')->nullable(); // Date of the email
            $table->boolean('is_seen')->default(false); // Seen status
            $table->boolean('is_star')->default(false); // Seen status
            $table->timestamps(); // Laravel's created_at and updated_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scheduled_emails');
    }
};
