<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('image_library', function (Blueprint $table) {
            $table->id();
            $table->string('template_type');
            $table->unsignedBigInteger('cgi_template');
            $table->foreign('cgi_template')->references('id')->on('cgi_video_templates')->onDelete('cascade');
            $table->string('image_template');
            $table->longText('canvas_data');
            $table->string('image_path');
            $table->string('width');
            $table->string('height');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('image_library');
    }
};
