<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ecommerce_widgets', function (Blueprint $table) {
            $table->id();
            $table->string('widget');
            $table->longText('widget_data');
            $table->enum('status', ['active', 'disabled'])->default('active');
            $table->unsignedBigInteger('project_id');
            $table->foreign('project_id')->references('ecommerce_subscription_id')->on('ecommerce_projects')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ecommerce_widgets');
    }
};
