<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  
        public function up()
        {
            Schema::create('mailboxes', function (Blueprint $table) {
                $table->id();
                $table->foreignId('staff_id')->constrained('users')->onDelete('cascade');
                $table->string('server_address');
                $table->string('server_user');
                $table->string('server_password');
                $table->enum('smtp_encryption', ['none', 'ssl', 'tls']);
                $table->enum('imap_encryption', ['none', 'ssl', 'tls']);
                $table->integer('smtp_port');
                $table->string('smtp_fromname');
                $table->string('imap_folder')->nullable();
                $table->integer('imap_port');
                $table->string('access_token')->nullable();
                $table->string('refresh_token')->nullable();
                $table->string('google_id')->nullable();
                $table->timestamps();
            });
        }
    
        public function down()
        {
            Schema::dropIfExists('mailboxes');
        }
    };
    
