<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('emails', function (Blueprint $table) {
            $table->id();
            $table->foreignId('staff_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('mailbox_id')->constrained('mailboxes')->onDelete('cascade');
            $table->string('from_email')->nullable();
            $table->string('from_name')->nullable();
            $table->string('to_email')->nullable();
            $table->string('subject')->nullable();
            $table->enum('direction', ['inbound', 'outbound'])->default('inbound');
            $table->longText('message')->nullable();
            $table->string('label')->nullable();
            $table->string('email_id')->nullable();
            $table->unsignedBigInteger('parent_email_id')->nullable();
            $table->timestamp('email_date')->nullable();
            $table->boolean('is_seen')->default(0);
            $table->boolean('is_star')->default(0);
            $table->boolean('is_imp')->default(0);
            $table->boolean('is_subscribed')->default(1);
            $table->boolean('is_delete')->default(0);
            $table->string('category')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('emails');
    }
};
