<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vcards', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('template');
            $table->string('vcard_name');
            $table->string('direction');
            $table->string('name');
            $table->string('occupation');
            $table->string('company_name');
            $table->string('company_slogan');
            $table->string('email');
            $table->string('phone');
            $table->string('address');
            $table->string('website_url');
            $table->longText('introduction');
            $table->longText('extras');
            $table->string('profile_image');
            $table->string('cover_image');
            $table->string('logo');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vcards');
    }
};
