<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('email_accounts', function (Blueprint $table) {
            // Add columns first, make them nullable
            $table->unsignedBigInteger('ecommerce_subscription_id')->nullable();
            $table->unsignedBigInteger('personal_subscription_id')->nullable();

            // Add foreign key constraints
            $table->foreign('ecommerce_subscription_id')
                  ->references('id')
                  ->on('user_ecommerce_subscriptions')
                  ->onDelete('cascade');

            $table->foreign('personal_subscription_id')
                  ->references('id')
                  ->on('projects')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('email_accounts', function (Blueprint $table) {
            // Drop foreign keys first
            $table->dropForeign(['ecommerce_subscription_id']);
            $table->dropForeign(['personal_subscription_id']);

            // Then drop columns
            $table->dropColumn(['ecommerce_subscription_id', 'personal_subscription_id']);
        });
    }
};
