<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('cpanel', function (Blueprint $table) {
            $table->string('changed_domain')->nullable()->after('password');
            $table->enum('connectivity_status', ['connected', 'pending', 'disconnected'])
            ->default('connected')
            ->after('changed_domain');
            $table->string('active_ip')->nullable()->after('connectivity_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('cpanel', function (Blueprint $table) {
            $table->dropColumn(['changed_domain', 'connectivity_status', 'active_ip']);
        });
    }
};
