<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_ecommerce_subscriptions', function (Blueprint $table) {
           if (!Schema::hasColumn('user_ecommerce_subscriptions', 'domain')) {
                $table->string('domain')->nullable();
            }

            if (!Schema::hasColumn('user_ecommerce_subscriptions', 'domain_api')) {
                $table->enum('domain_api', [
                    'user', 'namesilo', 'namecheap', 'aeserver', 'none'
                ])->default('none');
            }

            if (!Schema::hasColumn('user_ecommerce_subscriptions', 'domain_status')) {
                $table->enum('domain_status', [
                    'pending', 'active', 'inactive', 'propagation', 'expired', 'others'
                ])->default('pending');
            }

            if (!Schema::hasColumn('user_ecommerce_subscriptions', 'domain_price')) {
                $table->decimal('domain_price', 10, 2)->default(0.00);
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_ecommerce_subscriptions', function (Blueprint $table) {
            if (Schema::hasColumn('user_ecommerce_subscriptions', 'domain')) {
                $table->dropColumn('domain');
            }
            if (Schema::hasColumn('user_ecommerce_subscriptions', 'domain_api')) {
                $table->dropColumn('domain_api');
            }
            if (Schema::hasColumn('user_ecommerce_subscriptions', 'domain_status')) {
                $table->dropColumn('domain_status');
            }
            if (Schema::hasColumn('user_ecommerce_subscriptions', 'domain_price')) {
                $table->dropColumn('domain_price');
            }
        });
    }
};
