<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddBrowserToUrlVisitsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('url_visits', function (Blueprint $table) {
            $table->string('browser', 255)->nullable()->collation('utf8mb4_0900_ai_ci');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('url_visits', function (Blueprint $table) {
            $table->dropColumn('browser');
        });
    }
}
