<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Protected Link</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/short_links/css/global.css') }}">
    <style>
      body, html { min-height:100vh; }
      .glass-card{background:rgba(255,255,255,.15);backdrop-filter:blur(10px);border-radius:14px;border:1px solid rgba(255,255,255,.2)}
      .state-title{color:#fff}
    </style>
  </head>
  <body>
    <div class="container py-5">
      <div class="glass-card p-4 mx-auto" style="max-width:560px;">
        @if(($state ?? '') === 'prompt')
          <h4 class="state-title mb-2">🔒 This link is password protected.</h4>
          @if(!empty($error))
            <div class="alert alert-danger py-2">{{ $error }}</div>
          @endif
          <form method="post" action="{{ isset($link) ? url('go/'.$link->backhalf) : '#' }}">
            @csrf
            <div class="mb-3">
              <label class="text-white-50 mb-2">Enter Password</label>
              <input type="password" class="form-control" name="password" placeholder="Enter password" required>
            </div>
            <button class="btn btn-primary">Continue</button>
          </form>
        @elseif(($state ?? '') === 'expired')
          <h4 class="state-title mb-2">⚠️ This link has expired.</h4>
          <p class="text-white-50">The link you're trying to access is no longer active.</p>
          <a href="{{ url('/') }}" class="btn btn-outline-light">Go Back Home</a>
        @elseif(($state ?? '') === 'paused')
          <h4 class="state-title mb-2">⏸ This link is currently paused by the owner.</h4>
          <p class="text-white-50">Please try again later.</p>
          <a href="{{ url('/') }}" class="btn btn-outline-light">Go Back Home</a>
        @elseif(($state ?? '') === 'invalid')
          <h4 class="state-title mb-2">❌ Invalid short link.</h4>
          <p class="text-white-50">This link does not exist or has been removed.</p>
          <a href="{{ url('/') }}" class="btn btn-outline-light">Go Back Home</a>
        @endif
      </div>
    </div>
  </body>
 </html>
