@extends('shortlink::app')

@section('css')
<style>
 .card-white{background:#fff;border-radius:14px;box-shadow:0 6px 18px rgba(0,0,0,.1);border:1px solid rgba(0,0,0,.06)}
 .stat-num{font-size:2rem;font-weight:800;color:#111}
 .chart-card{min-height:340px}
 .referrer-list {
    max-height: 200px;
    overflow-y: auto;
    padding-right: 10px;
 }
 .referrer-list li {
    padding: 5px 0;
    border-bottom: 1px solid #eee;
    margin-bottom: 5px;
 }
 .referrer-list li:last-child {
    border-bottom: none;
    margin-bottom: 0;
 }
 .chart-container {
    position: relative;
    height: 300px;
    width: 100%;
 }
</style>
@endsection

@section('content')
<div class="container py-4">
  <div class="betweenflex mt-3 align-items-center">
    <h4 class="text-white m-0">Stats: {{ $link->short_link }}</h4>
    <a href="{{ url('crm/projects/short-links') }}" class="btn btn-dark transparent-btn fs-6">Back to list</a>
  </div>

  <!-- Stats Cards -->
  <div class="row g-3 mt-2">
    <div class="col-md-3">
      <div class="card-white p-4 h-100">
        <div class="text-muted">Total Clicks</div>
        <div class="stat-num">{{ number_format($totalClicks) }}</div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card-white p-4 h-100">
        <div class="text-muted">Unique Visitors</div>
        <div class="stat-num">{{ number_format($uniqueVisitors) }}</div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card-white p-4 h-100">
        <div class="text-muted">Top Countries</div>
        <div class="stat-num">{{ $countries->count() }}</div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card-white p-4 h-100 d-flex align-items-center justify-content-center">
        <img src="https://api.qrserver.com/v1/create-qr-code/?size=120x120&data={{ urlencode($link->short_link) }}" alt="QR" class="rounded"/>
      </div>
    </div>
  </div>

  <!-- Top Referrers -->
  <div class="row g-3 mt-3">
    <div class="col-md-12">
      <div class="card-white p-4">
        <h5 class="mb-3">Top Referrers</h5>
        <div class="referrer-list">
          @forelse($referrers as $r)
            <div class="d-flex justify-content-between align-items-center">
              <div class="text-truncate" style="max-width: 80%;" title="{{ $r->referrer }}">
                {{ $r->referrer }}
              </div>
              <span class="badge bg-primary">{{ $r->clicks }} clicks</span>
            </div>
          @empty
            <div class="text-muted">No referrer data available</div>
          @endforelse
        </div>
      </div>
    </div>
  </div>

  <!-- Charts Row 1: Countries & Browsers -->
  <div class="row g-3 mt-3">
    <div class="col-md-6">
      <div class="card-white p-4 h-100">
        <h5 class="mb-3">Top Countries</h5>
        <div class="chart-container">
          <canvas id="countriesChart"></canvas>
        </div>
      </div>
    </div>
    <div class="col-md-6">
      <div class="card-white p-4 h-100">
        <h5 class="mb-3">Browsers</h5>
        <div class="chart-container">
          <canvas id="browsersChart"></canvas>
        </div>
      </div>
    </div>
  </div>

  <!-- Charts Row 2: Devices & Daily Clicks -->
  <div class="row g-3 mt-3">
    <div class="col-md-6">
      <div class="card-white p-4 h-100">
        <h5 class="mb-3">Devices</h5>
        <div class="chart-container">
          <canvas id="devicesChart"></canvas>
        </div>
      </div>
    </div>
    <div class="col-md-6">
      <div class="card-white p-4 h-100">
        <h5 class="mb-3">Clicks Over Time (Last 30 Days)</h5>
        <div class="chart-container">
          <canvas id="dailyChart"></canvas>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
(function(){
  // Data from controller
  const countries = @json($countries ?? []);
  const devices = @json($devices ?? []);
  const browsers = @json($browsers ?? []);
  const daily = @json($daily ?? []);

  // Helper function to prepare data for charts
  const prepareChartData = (data, key) => {
    if (!data || !data.length) {
      return { labels: ['No data'], data: [0], total: 0 };
    }
    
    const labels = [];
    const values = [];
    let total = 0;
    
    data.forEach(item => {
      const label = item[key] || 'Unknown';
      const value = Number(item.clicks) || 0;
      labels.push(label);
      values.push(value);
      total += value;
    });
    
    return { labels, data: values, total };
  };

  // Chart colors
  const chartColors = [
    '#3b82f6', '#10b981', '#f59e0b', '#ef4444', '#8b5cf6', 
    '#ec4899', '#14b8a6', '#f97316', '#6366f1', '#d946ef'
  ];

  // Initialize all charts
  function initCharts() {
    // Countries Chart
    const countriesCtx = document.getElementById('countriesChart');
    if (countriesCtx) {
      const countriesData = prepareChartData(countries, 'country');
      new Chart(countriesCtx, {
        type: 'doughnut',
        data: {
          labels: countriesData.labels,
          datasets: [{
            data: countriesData.data,
            backgroundColor: chartColors,
            borderWidth: 0,
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: {
            legend: { 
              position: 'right',
              labels: { padding: 15 }
            },
            tooltip: {
              callbacks: {
                label: function(context) {
                  const label = context.label || '';
                  const value = context.raw || 0;
                  const total = context.dataset.data.reduce((a, b) => a + b, 0);
                  const percentage = Math.round((value / total) * 100);
                  return `${label}: ${value} (${percentage}%)`;
                }
              }
            }
          }
        }
      });
    }

    // Browsers Chart
    const browsersCtx = document.getElementById('browsersChart');
    if (browsersCtx) {
      const browsersData = prepareChartData(browsers, 'browser');
      new Chart(browsersCtx, {
        type: 'pie',
        data: {
          labels: browsersData.labels,
          datasets: [{
            data: browsersData.data,
            backgroundColor: chartColors,
            borderWidth: 0,
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: {
            legend: { 
              position: 'right',
              labels: { padding: 15 }
            },
            tooltip: {
              callbacks: {
                label: function(context) {
                  const label = context.label || '';
                  const value = context.raw || 0;
                  const total = context.dataset.data.reduce((a, b) => a + b, 0);
                  const percentage = Math.round((value / total) * 100);
                  return `${label}: ${value} (${percentage}%)`;
                }
              }
            }
          }
        }
      });
    }

    // Devices Chart
    const devicesCtx = document.getElementById('devicesChart');
    if (devicesCtx) {
      const devicesData = prepareChartData(devices, 'device');
      new Chart(devicesCtx, {
        type: 'doughnut',
        data: {
          labels: devicesData.labels,
          datasets: [{
            data: devicesData.data,
            backgroundColor: chartColors,
            borderWidth: 0,
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: {
            legend: { 
              position: 'right',
              labels: { padding: 15 }
            },
            tooltip: {
              callbacks: {
                label: function(context) {
                  const label = context.label || '';
                  const value = context.raw || 0;
                  const total = context.dataset.data.reduce((a, b) => a + b, 0);
                  const percentage = Math.round((value / total) * 100);
                  return `${label}: ${value} (${percentage}%)`;
                }
              }
            }
          }
        }
      });
    }

    // Daily Clicks Chart
    const dailyCtx = document.getElementById('dailyChart');
    if (dailyCtx) {
      const labels = daily.map(d => {
        const date = new Date(d.day);
        return date.toLocaleDateString('en-US', { month: 'short', day: 'numeric' });
      });
      const data = daily.map(d => d.clicks);
      
      new Chart(dailyCtx, {
        type: 'line',
        data: {
          labels: labels,
          datasets: [{
            label: 'Clicks',
            data: data,
            borderColor: '#3b82f6',
            backgroundColor: 'rgba(59, 130, 246, 0.1)',
            borderWidth: 2,
            tension: 0.3,
            fill: true,
            pointBackgroundColor: '#fff',
            pointBorderColor: '#3b82f6',
            pointBorderWidth: 2,
            pointRadius: 4,
            pointHoverRadius: 6,
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          scales: {
            y: { 
              beginAtZero: true,
              grid: { color: 'rgba(0, 0, 0, 0.05)' }
            },
            x: {
              grid: { display: false }
            }
          },
          plugins: {
            legend: { display: false },
            tooltip: {
              backgroundColor: 'rgba(0, 0, 0, 0.8)',
              titleFont: { size: 14, weight: 'bold' },
              bodyFont: { size: 13 },
              padding: 12,
              displayColors: false,
              callbacks: {
                label: function(context) {
                  return `Clicks: ${context.raw}`;
                }
              }
            }
          }
        }
      });
    }
  }

  // Initialize charts when the page loads
  document.addEventListener('DOMContentLoaded', initCharts);
})();
</script>
@endsection
