@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Add Blog Posts') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Blogs') }}</div>
                        </div>
                        <div class="col-md-8" style="text-align: right">
                            <a href="{{url('admin/blog')}}" class="btn btn-md btn-primary">Blog</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="form-group">
                                <label for="">Enter Title</label>
                                <input type="text" name="title" id="subject" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-md btn-primary" id="generateUsingAi"
                                style="margin-top:34px;width:100%;">Generate AI</button>
                        </div>
                        <div class="col-md-12 mt-3">
                            <div class="form-group">
                                <label for="">Description</label>
                                <textarea name="description" class="form-control" id="description" style="width:100%;height:200px;"></textarea>
                            </div>
                        </div>
                        <div class="col-md-12 mt-3">
                            <div class="form-group">
                                <label for="">Upload Image</label>
                                <input type="file" name="upload_image" id="upload_image" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12 mt-3" style="text-align: right">
                            <button class="btn btn-md btn-primary" id="addPost">Add Post</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();


        });
    </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        $("#generateUsingAi").on('click', function() {
            var btn = $(this);
            var btn_html = btn.html();

            var subject = $("#subject").val();
            if (!subject) {
                Swal.fire({
                    title: "Error",
                    text: "Please enter subject",
                    icon: "warning"
                })
                return;
            }

            btn.html('<i class="fa fa-spinner fa-spin"></i>')

            var data = {
                _token: '<?= csrf_token() ?>',
                subject: subject
            };
            var url = '<?= url('social/post/generate_using_ai') ?>';
            $.post(url, data, function(data) {
                if (!data.result) {
                    Swal.fire({
                        title: "Error",
                        text: "Some error occured",
                        icon: "error"
                    })
                    return;
                }

                var msg = data.msg;
                $("#description").val(msg);

            });
        });
    </script>
    <script>
        $("#addPost").on('click', function(){
            var btn = $(this);
            var btn_html = btn.html();            
            let formData = new FormData();
            let imageFile = $('#upload_image')[0].files[0];
            if (imageFile) {
                formData.append('image', imageFile);
            }
            var description = $("#description").val();
            var title = $("#subject").val();
            formData.append('title', title);
            formData.append('description', description);
            formData.append('_token', '<?=csrf_token(); ?>')
            btn.html("<i class='fa fa-spinner fa-spin'></i>");
            var url = '<?=url('/admin/blog/add'); ?>';
            $.ajax({
            url: url, 
            type: 'POST',
            data: formData,
            processData: false, 
            contentType: false,
            success: function (response) {
                Swal.fire({
                    title:"Post Added",
                    text:"Post added successfully",
                    icon:"success"
                }).then(function(){
                    location.reload();
                })
            },
            error: function (xhr) {
                let errors = xhr.responseJSON.errors;
                let errorMessage = 'Error uploading image.';
                if (errors && errors.image) {
                    errorMessage = errors.image[0];
                }
                Swal.fire({
                    title:"Error",
                    text:errorMessage,
                    icon:"error"
                })
            }
        });
        });
    </script>
@endsection
