@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
  
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="card-title d-inline-block">{{ __('Blogs') }}</div>
                        </div>
                         <div class="col-md-4" style="text-align: right">
                            <a href="{{url('admin/blog/add')}}" class="btn btn-md btn-primary">Add Post</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                   <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-hover table-stripped" id="dataTable">
                                        <thead>
                                            <th>Image</th>
                                            <th>Title</th>
                                            <th>Created At</th>
                                            <th>Action</th>
                                        </thead>
                                        <tbody>
                                            @foreach ($posts as $post)
                                                <tr>
                                                    <td>
                                                        <img src="{{asset('storage/'.$post->image)}}" style="width:50px;height:50px;object-fit:cover;">
                                                    </td>
                                                    <td>
                                                        {{$post->title}}
                                                    </td>
                                                    <td>
                                                        {{date('d F Y H:i', strtotime($post->created_at))}}
                                                    </td>
                                                    <td>
                                                        <a href="{{url('admin/blog/view/'.$post->id)}}" class="btn btn-sm btn-primary view_post" data-id="{{$post->id}}">View</a>
                                                        <button class="btn btn-sm btn-danger delete_post" data-id="{{$post->id}}">Delete</button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                </div>
            </div>
        </div>
    </div>

  

@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();

            
        });
    </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        $(document).on('click', '.delete_post', function(){
            var id = $(this).attr('data-id');
                Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    var url = '<?=url('admin/blog/delete'); ?>';
                    $.post(url, {id:id, _token:'<?=csrf_token(); ?>'}, function(){
                        Swal.fire({
                            title:"Post Deleted",
                            text:"Post Deleted Successfully",
                            icon:"success"
                        }).then(function(){
                            location.reload();
                        })
                    });
                }
            });
        });
    </script>
  
@endsection
