@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
  
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="card-title d-inline-block">{{ __('Categories') }}</div>
                        </div>
                        <div class="col-md-4" style="text-align: right">
                            <button class="btn btn-md btn-primary" style="border-radius: 20px;" id="addCategory">Add Category</button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                   <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-hover table-stripped" id="dataTable">
                                        <thead>
                                            <th>Category</th>
                                            <th>Action</th>
                                        </thead>
                                        <tbody>
                                            @foreach ($categories as $category)
                                                <tr>
                                                    <td>
                                                        {{$category->category}}
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-sm btn-danger delete_category" data-id="{{$category->id}}">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                        <button class="btn btn-sm btn-warning edit_category" data-id="{{$category->id}}" data-category="{{$category->category}}">
                                                            <i class="fa fa-pencil"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="categoryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Category</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Enter Category</label>
                                <input type="text" name="category" id="category" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary" id="add_category_btn">Add Category</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateCategoryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update Category</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <input type="hidden" name="cat_id" id="cat_id">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Enter Category</label>
                                <input type="text" name="category" id="ucategory" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary" id="updateCatBtn">Update Category</button>
                </div>
            </div>
        </div>
    </div>


@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();

            
        });
    </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        $("#addCategory").on('click', function(){
            $("#categoryModal").modal('show');
        });

        $(document).on('click', '.delete_category', function(){
            var id = $(this).attr('data-id');
             Swal.fire({
                title: "Are you sure?",
                text: "Do you really want to delete this category? This action cannot be undone.",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "Cancel"
            }).then((result) => {
                if (result.isConfirmed) {
                    var url = "{{route('categories.delete')}}";
                    var data = {_token:'<?=csrf_token(); ?>', id:id};
                    $.post(url, data, function(data){
                        if(data.result)
                        {
                            Swal.fire({
                                title:"Category Deleted",
                                text:"Category Deleted Successfully",
                                icon:"success"
                            }).then(function(){
                                location.reload();
                            })   

                            return;
                        }
                    });
                }
            });
        })

        $("#add_category_btn").on('click', function(){
            var btn = $(this);
            var btn_html = btn.html();
            var category = $("#category").val();
            if(!category)
            {
                Swal.fire({
                    title:"Error",
                    text:"Enter category",
                    icon:"error"
                })
                return;   
            }
            btn.html("<i class='fa fa-spinner fa-spin'></i>")
            var data = {category:category, _token:'<?=csrf_token(); ?>'};
            var url = "{{route('categories.add')}}";
            $.post(url, data, function(data){
                if(!data.result)
                {
                    Swal.fire({
                        title:"Error",
                        text:data.msg,
                        icon:"error"
                    })              
                    return;     
                }

                Swal.fire({
                    title:"Category Created",
                    text:"Category Created Successfully",
                    icon:"success"
                }).then(function(){
                    location.reload();
                })
            })
        });
    </script>
    <script>
        $(document).on('click', '.edit_category', function(){
            var category = $(this).attr('data-category');
            var id = $(this).attr('data-id');
            $("#ucategory").val(category);
            $("#cat_id").val(id);
            $("#updateCategoryModal").modal('show');
        });
    </script>
    <script>
        $("#updateCatBtn").on('click', function(){
            var catId = $("#cat_id").val();
            var category = $("#ucategory").val();
           
            var data = {id:catId, category:category, _token:"<?=csrf_token(); ?>"};
            var url = "{{route('categories.update')}}";
            $.post(url, data, function(data){
                if(data.result)
                {
                    Swal.fire({
                        title:"Category Updated",
                        text:"Category updated successfully",
                        icon:"success"
                    }).then(function(){
                        location.reload()
                    })   
                }
            });
        });
    </script>
@endsection
