@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Cgi Template') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Add Cgi Template') }}</div>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Video Name</label>
                                <input type="text" name="video_name" id="video_name" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="">Template ID</label>
                                <input type="text" name="templateId" id="templateId" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="">Category</label>
                                <select name="category" id="category" class="form-control">
                                    @if (!$categories->isEmpty())
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}">
                                                {{ $category->category }}
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="">Price</label>
                                <input type="text" name="price" id="price" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Video Upload</label>
                                <input type="file" name="video" id="video" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Video Text File</label>
                                <input type="file" name="video_text" id="video_text_file" class="form-control">
                            </div>
                        </div>
                       
                        <div class="col-md-12" style="text-align: right">
                            <button class="btn btn-sm btn-primary" id="add3dModalRow">Add 3d Modal</button>
                        </div>
                        <div class="col-md-12" id="modalRow">

                        </div>

                        <div class="col-md-12 mt-3" style="text-align: right">
                            <button class="btn btn-sm btn-primary" id="addImageBtn">Add More Images</button>
                        </div>

                        <div class="col-md-12" id="imageRow">
                            
                        </div>


                        <div class="col-md-12" style="text-align: right">
                            <button class="btn btn-sm btn-primary" id="addvideoBtn">Add Videos</button>
                        </div>

                        <div class="col-md-12" id="videoRow">

                        </div>


                    </div>
                </div>
                <div class="card-footer" style="text-align: right;">
                    <button class="btn btn-md btn-primary" id="addTemplate">Add Template</button>
                </div>
            </div>
        </div>
    </div>


@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();


        });
    </script>
    <script>
        $('#addTemplate').on('click', function(e) {
            e.preventDefault();
            let formData = new FormData();
            formData.append('video_name', $('#video_name').val());
            formData.append('video', $('#video')[0].files[0]);
            formData.append('video_text', $('#video_text_file')[0].files[0]);
            var templateId = $("#templateId").val();

            let videos = [];

            let videoHeights = [];
            let videoWidths = [];
            let videoNames = [];
            let videoInfos = [];

            $(".video_name").each(function() {
                var videoName = $(this).val();
                if (videoName) {
                    videoNames.push(videoName);
                }
            });
            $(".video_height").each(function() {
                var videoHeight = $(this).val();
                if (videoHeight) {
                    videoHeights.push(videoHeight);
                }
            });
            $(".video_width").each(function() {
                var videoWidth = $(this).val();
                if (videoWidth) {
                    videoWidths.push(videoWidth);
                }
            });
            $(".video_information").each(function() {
                var videoInfo = $(this).val();
                if (videoInfo) {
                    videoInfos.push(videoInfo);
                }
            });


            if (videoNames.length > 0) {
                var count = 0;
                videoNames.forEach(name => {
                    var height = videoHeights[count];
                    var width = videoHeights[count];
                    var info = videoInfos[count];

                    var videoData = {
                        height: height,
                        width: width,
                        info: info,
                        name: name
                    };
                    videos.push(videoData);

                    count++;
                });
            }


            let imageHeights = [];
            let imageWidths = [];
            let imageNames = [];
            let imageInformations = [];
            let imagePaths = [];

            $(".image_path").each(function(){
                var path = $(this).val();
                imagePaths.push(path);
            });

            $(".image_width").each(function() {
                var width = $(this).val();
                imageWidths.push(width);
            });

            $(".image_height").each(function() {
                var height = $(this).val();
                imageHeights.push(height);
            });

            $(".image_name").each(function() {
                var imageName = $(this).val();
                imageNames.push(imageName);
            });

            $(".image_information").each(function() {
                var information = $(this).val();
                imageInformations.push(information);
            })

            var modalData = [];

            $(".modalIds").each(function(index) {
                modalData.push({
                    modal_id: $(this).val(),
                    modal_path: $(".modalPaths").eq(index).val(),
                    image_connected:$(".imageConnected").eq(index).val()
                });
            });
           


            imageWidths = JSON.stringify(imageWidths);
            imageHeights = JSON.stringify(imageHeights);
            imageNames = JSON.stringify(imageNames);
            imageInformations = JSON.stringify(imageInformations);
            modalData = JSON.stringify(modalData);
            imagePaths = JSON.stringify(imagePaths);

            let emptyFields = [];
            if (!$('#video_name').val()) emptyFields.push('Video Name');
            if (!$('#video')[0].files.length) emptyFields.push('Video Upload');
            if (!$('#video_text_file')[0].files.length) emptyFields.push('Video Text File');
            if (!$("#price").val()) emptyFields.push('Price');

            formData.append('price', $("#price").val());
            formData.append('heights', imageHeights);
            formData.append('widths', imageWidths);
            formData.append('image_names', imageNames);
            formData.append('image_information', imageInformations);
            formData.append('template_id', templateId);
            formData.append('image_paths', imagePaths);
           
            formData.append('model_data', modalData);

            if (videos.length > 0) {
                var jsonVideos = JSON.stringify(videos);
                formData.append('videos', jsonVideos);
            }


            var categoryId = $("#category").val();
            formData.append('category', categoryId);

            if (emptyFields.length > 0) {
                Swal.fire({
                    title: "Error",
                    text: "Please fill all the required fields",
                    icon: "error"
                })
                return;
            }

            formData.append('_token', "{{ csrf_token() }}");

            var storeUrl = "{{ route('admin.cgi.template.store') }}";

            $.ajax({
                url: storeUrl, // Replace with your server endpoint
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    Swal.fire({
                        title: "Template added",
                        text: "Template added successfully",
                        icon: "success"
                    }).then(function() {
                        location.reload();
                    })
                },
                error: function(xhr) {
                    if (xhr.responseText) {
                        var messages = JSON.parse(xhr.responseText);
                        if (messages.message) {
                            Swal.fire({
                                title: "Error",
                                text: messages.message,
                                icon: "error"
                            })
                            return;
                        }
                    }
                }
            });
        });
    </script>
    <script>
        $(document).on('click', '#addImageBtn', function() {
            var row = '<div class="row g-0">\
                        <div class="col p-1">\
                            <div class="form-group">\
                                <label for="">Name</label>\
                                <input type="text" name="image_name[]" class="form-control image_name">\
                            </div>\
                        </div>\
                        <div class="col p-1">\
                            <div class="form-group">\
                                <label for="">Image Height</label>\
                                <input type="text" name="image_height[]" class="form-control image_height">\
                            </div>\
                        </div>\
                        <div class="col p-1">\
                            <div class="form-group">\
                                <label for="">Image Width</label>\
                                <input type="text" name="image_width[]" class="form-control image_width">\
                            </div>\
                        </div>\
                        <div class="col p-1">\
                            <div class="form-group">\
                                <label for="">Image Path</label>\
                                <input type="text" name="image_path[]" class="form-control image_path">\
                            </div>\
                        </div>\
                        <div class="col p-1">\
                            <div class="form-group">\
                                <label for="">Image Information</label>\
                                <input type="text" name="image_information[]" class="form-control image_information">\
                            </div>\
                        </div>\
                        <div class="col p-1">\
                            <button class="btn btn-sm btn-danger removeRow" style="margin-top:30px;">\
                                <i class="fa fa-times"></i>\
                            </button>\
                        </div>\
                    </div>';

            $("#imageRow").append(row);
        });


        $("#addvideoBtn").on('click', function() {

            var row = '<div class="row">\
                                        <div class="col-md-4">\
                                            <div class="form-group">\
                                                <label for="">Video Name</label>\
                                                <input type="text" name="video_name[]" class="form-control video_name">\
                                            </div>\
                                        </div>\
                                        <div class="col-md-2">\
                                            <div class="form-group">\
                                                <label for="">Video Height</label>\
                                                <input type="text" name="video_height[]" class="form-control video_height">\
                                            </div>\
                                        </div>\
                                        <div class="col-md-2">\
                                            <div class="form-group">\
                                                <label for="">Video Width</label>\
                                                <input type="text" name="video_width[]" class="form-control video_width">\
                                            </div>\
                                        </div>\
                                        <div class="col-md-3">\
                                            <div class="form-group">\
                                                <label for="">Video Information</label>\
                                                <input type="text" name="video_infomation[]" class="form-control video_information">\
                                            </div>\
                                        </div>\
                                        <div class="col-md-1">\
                                            <button class="btn btn-sm btn-danger removeRow" style="margin-top:38px;"><i class="fa fa-times"></i></button>\
                                        </div>\
                                    </div>';
            $("#videoRow").append(row);

        });


        $(document).on('click', '.removeRow', function() {
            $(this).closest('.row').remove(); // Fixed selector
        });
    </script>
    <script>
        $(document).ready(function () {
        $("#add3dModalRow").click(function () {
            let fieldHTML = `
                <div class="row align-items-center mb-2 field-group">
                    <div class="col-md-4">
                        <input type="text" class="form-control modalIds" placeholder="Model Id">
                    </div>
                    <div class="col-md-4">
                        <input type="text" class="form-control modalPaths" placeholder="Model Path">
                    </div>
                    <div class="col-md-2">
                        <input type="text" class="form-control imageConnected" placeholder="Image">
                    </div>
                    <div class="col-md-2 text-end">
                        <button class="btn btn-danger btn-sm removeModalField">Remove</button>
                    </div>
                </div>`;
            $("#modalRow").append(fieldHTML);
        });

        // Remove field row
        $(document).on("click", ".removeModalField", function () {
            $(this).closest(".field-group").remove();
        });
    });
    </script>
@endsection
