@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/dropzone.min.css">


@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Cgi Library') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Add Cgi Image') }}</div>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-5">
                            <div class="form-group">
                                <label for="">Templates</label>
                                <select name="tempalte" id="template" class="form-control" multiple="multiple" style="width: 100%;">
                                    <option value="0">Select Template</option>
                                    @if (!$templates->isEmpty())
                                        @foreach ($templates as $template)
                                            <option value="{{$template->id}}">
                                                {{$template->template_name}}
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label for="">Section</label>
                                <select name="tempalte" id="sections" class="form-control" multiple="multiple" style="width: 100%;">
                                    <option value="0">Select Section</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-sm btn-primary" id="showImages" style="width:100%;margin-top:35px;">Show</button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <form action="{{ route('admin.cgi.library.add_image') }}" method="POST"
                                enctype="multipart/form-data" class="dropzone" id="image-upload" style="width:100%;">
                                @csrf
                            </form>
                        </div>
                    </div>
                </div>
                <div class="card-footer" style="text-align: right;">
                    <button class="btn btn-md btn-primary" id="uploadBtn">Add Images</button>
                </div>
            </div>
        </div>
    </div>
    <div class="row mt-3" id="cardImages">

    </div>


@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/dropzone.min.js"></script>


    <script>
        $(document).ready(function() {
            var table = $("#dataTable").DataTable();
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#template').select2({
                placeholder: "Select Template", // Add a placeholder
                allowClear: true // Allow clearing selected options
            });

            $("#sections").select2({
                placeholder: "Select Sections", // Add a placeholder
                allowClear: true // Allow clearing selected options
            })

              $('#template').on('change', function() {
                let selectedValues = $(this).val(); // Get selected values
                if (selectedValues) {
                    if(selectedValues.length > 0)
                    {
                        var data = {_token:"{{csrf_token()}}", templates:selectedValues};
                        var url = "{{route('admin.cgi.template_sections')}}";
                        $.get(url, data, function(data){
                            if(data.length > 0)
                            {
                                $("#sections").empty().trigger('change');
                                data.forEach(sectionData => {
                                    $("#sections").append(new Option(sectionData.name + " (" +sectionData.template+ ")", sectionData.template_id + "--"+sectionData.name)).trigger('change');
                                });   
                            }
                        });
                    }
                }
            });
        });
    </script>
  <script>
    Dropzone.options.imageUpload = {
        autoProcessQueue: false,
        acceptedFiles: "image/*",
        parallelUploads: 999,
        init: function () {
            var myDropzone = this;
            var btn = $("#uploadBtn");
            var btn_html = btn.html();
            var uploadedFileLinks = []; // Array to store file links

            console.log("Initialized");
            document.getElementById("uploadBtn").addEventListener("click", function (e) {
                e.preventDefault();
                e.stopPropagation();
                btn.html("<i class='fa fa-spinner fa-spin'></i>");

                if (myDropzone.getQueuedFiles().length > 0) {
                    uploadedFileLinks = []; // Reset the array before processing
                    myDropzone.processQueue();
                } else {
                    alert("No files to upload!");
                }
            });

            myDropzone.on("addedfile", function (file) {
                console.log(file);
                var removeButton = Dropzone.createElement(
                    '<button class="btn btn-danger btn-sm remove-btn" style="border-radius: 0px; position: absolute; top: 0px; z-index: 99999;"><i class="fa fa-trash"></i></button>'
                );
                removeButton.addEventListener("click", function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    myDropzone.removeFile(file);
                });
                file.previewElement.appendChild(removeButton);
            });

            this.on("complete", function (file) {
                var allFilesUploaded =
                    this.getAcceptedFiles().length === this.getFilesWithStatus(Dropzone.SUCCESS).length;

                if (allFilesUploaded) {
                    Swal.fire('Upload Complete!', 'All files were uploaded successfully.', 'success');
                    btn.html(btn_html);
                    
                    this.removeAllFiles();
                }
            });

            myDropzone.on("success", function (file, response) {
                console.log(response);
                if (response && response.file_link) {
                    uploadedFileLinks.push(response.file_link); // Collect the file link
                }
                console.log("Upload successful:", response);
            });

            myDropzone.on("sending", function (file, xhr, formData) {
                var sections = $("#sections").val();
                formData.append('sections', sections);
            });

            myDropzone.on("error", function (file, response) {
                console.error("Upload failed:", response);
                btn.html(btn_html);
            });
        }
    };
</script>
<script>
    $(document).on('click', '#showImages', function(){
        $("#cardImages").html("");
        var sections = $("#sections").val();
        var templates = $("#template").val();
        if((sections.length > 0) && (templates.length > 0))
        { 
            var data = {_token:"{{csrf_Token()}}", sections:sections, templates:templates};
            var url = "{{route('cgi.getImages')}}";
            $.post(url, data, function(data){
                if(data.length > 0)
                {
                    data.forEach(image => {
                        var imageUrl = image.url;
                        var imageId = image.id;
                        var string = '<div class="col-md-3"><div class="card"><div class="card-body"><img src="'+imageUrl+'" style="width:100%;height:300px;object-fit:cover;" /></div><div class="card-footer"><button class="btn btn-md btn-danger removeImageLibrary" data-id="'+imageId+'" style="width:100%;">Delete</button></div></div></div>';
                        $("#cardImages").append(string);
                    });   
                }
            })
        }

    });

    $(document).on('click', '.removeImageLibrary', function(){
        var imageId = $(this).attr('data-id');
        var routeUrl = "{{route('cgi.removeLibraryImage')}}";
        var data = {_token:"{{csrf_token()}}", id:imageId};
        var imageBtn = $(this);
        
        $.post(routeUrl, data, function(data){
            imageBtn.closest('.col-md-3').remove();
        });
    });
</script>

@endsection
