@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Cgi Videos') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Cgi Videos List') }}</div>
                        </div>
                       
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        
                                        <th>Template Id</th>
                                        <th>Template</th>
                                        <th>Video</th>
                                        <th>Text File</th>
                                        <th>Image</th>
                                        <th>Action</th>
                                    </thead>
                                    <tbody>
                                        @if (!$templates->isEmpty())
                                            @foreach ($templates as $template)
                                                <tr>
                                                    <td>
                                                        {{$template->template_id}}
                                                    </td>
                                                    <td>
                                                        {{$template->template_name}}
                                                    </td>
                                                    <td>
                                                        <a target="_blank" href="{{url('public/'.$template->video)}}" class="btn btn-sm btn-primary">View</a>
                                                    </td>
                                                    <td>
                                                        <a target="_blank" href="{{url('public/'.$template->text_file)}}" class="btn btn-sm btn-primary">View</a>
                                                    </td>
                                                    <td>
                                                        @php
                                                            $imageNames= json_decode($template->image_names);
                                                            foreach ($imageNames as $name) {
                                                                echo $name."<br/>";
                                                            }
                                                        @endphp

                                                    </td>
                                                    <td>
                                                        <a class="btn btn-sm btn-warning" href="{{route('admin.cgi.template.edit', ['id'=>$template->id])}}">Edit</a>
                                                        <button class="btn btn-sm btn-danger delete" data-id="{{$template->id}}">Delete</button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>




@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();


        });

        $(document).on('click', '.delete', function(){
            var id = $(this).attr('data-id');
            var url = "{{route('admin.cgi.template.delete')}}";

            Swal.fire({
                title: 'Are you sure?',
                text: "Do you really want to delete this template?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.post(url, { _token: "{{csrf_token()}}", id: id }, function (response) {
                      
                        if (response.result) {
                            Swal.fire(
                                'Deleted!',
                                'Templated deleted successfully.',
                                'success'
                            ).then(function(){
                                location.reload();
                            });
                        } else {
                            Swal.fire(
                                'Failed!',
                                response.msg || 'Failed to delete template.',
                                'error'
                            );
                        }
                    }).fail(function () {
                        // Handle any AJAX errors
                        Swal.fire(
                            'Error!',
                            'An error occurred while processing your request.',
                            'error'
                        );
                    });
                }
            });
        });

    </script>
 
  
@endsection
