@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('3d Modals') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('3d Modals') }}</div>
                        </div>
                       
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        
                                        <th>Modal</th>
                                        <th>Action</th>
                                    </thead>
                                    <tbody>
                                        @if (!empty($folders))
                                            @foreach ($folders as $folder)
                                                <tr>
                                                    <td>
                                                        {{str_replace('_', ' ', $folder)}}
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-sm btn-danger removeModal" data-folder="{{$folder}}">Remove</button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>




@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();


        });

        $(document).on('click', '.removeModal', function(){
            var folder = $(this).attr('data-folder');
            var url = "{{route('3dmodals.remove')}}";

            Swal.fire({
                title: 'Are you sure?',
                text: "Do you really want to delete this template?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.post(url, { _token: "{{csrf_token()}}", folder: folder }, function (response) {
                      
                        if (response.result) {
                            Swal.fire(
                                'Deleted!',
                                'Modal deleted successfully.',
                                'success'
                            ).then(function(){
                                location.reload();
                            });
                        } else {
                            Swal.fire(
                                'Failed!',
                                response.msg || 'Failed to delete template.',
                                'error'
                            );
                        }
                    }).fail(function () {
                        // Handle any AJAX errors
                        Swal.fire(
                            'Error!',
                            'An error occurred while processing your request.',
                            'error'
                        );
                    });
                }
            });
        });

    </script>
 
  
@endsection
