@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Cgi Orders') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Cgi Orders List') }}</div>
                        </div>
                       
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        <th style="display:none;">
                                            ID
                                        </th>
                                        <th>Template</th>
                                        <th>User</th>
                                        <th>Video Status</th>
                                        <th>Transaction Id</th>
                                        <th>Amount</th>
                                        <th>Order Date</th>
                                    </thead>
                                    <tbody>
                                        @if (!$orders->isEmpty())
                                            @foreach ($orders as $order)
                                                <tr>
                                                    <td style="display: none;">
                                                        {{$order->id}}
                                                    </td>
                                                    <td>
                                                        {{$order->templates->template_name}}
                                                    </td>
                                                    <td>
                                                        {{$order->user->email}} 
                                                    </td>
                                                    <td>
                                                        {{ucfirst($order->status)}}
                                                        @if ($order->status == 'completed')
                                                            <br>
                                                            <a target="_blank" href="{{url('public/videos/'.$order->generated_video)}}">View</a>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if ($order->transaction)
                                                            {{$order->transaction->transaction_id}}
                                                        @else
                                                            Free
                                                        @endif
                                                    </td>
                                                    <td>
                                                        
                                                        @if ($order->transaction)
                                                            {{currency_symbol()}}{{$order->transaction->amount}}
                                                        @else
                                                            Free
                                                        @endif
                                                    </td>
                                                    <td data-order="{{ strtotime($order->created_at) }}">
                                                        {{date('d F Y H:i', strtotime($order->created_at))}}
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>




@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
           var table = $("#dataTable").DataTable({
                order: [[0, "desc"]]
            });

        });

      
    </script>
 
  
@endsection
