@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Cpanel') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Cpanels List') }}</div>
                        </div>
                        <div class="col-md-8" style="text-align: right">
                            <button class="btn btn-md btn-primary" id="addCpanelAccount">Add Cpanel</button>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        <th>Whm</th>
                                        <th>Domain</th>
                                        <th>User</th>
                                        <th>Web type</th>
                                        <th>Action</th>
                                        <th>Database</th>
                                    </thead>
                                    <tbody>
                                        @if (!$cpanels->isEmpty())
                                            @foreach ($cpanels as $cpanel)
                                                <tr>
                                                    <td>
                                                        {{$cpanel->whm_name}}
                                                    </td>
                                                    <td>
                                                        {{$cpanel->domain}}
                                                    </td>
                                                    <td>
                                                        {{$cpanel->user}}
                                                    </td>
                                                    <td>
                                                        {{ucfirst($cpanel->cpanel_type)}}
                                                    </td>
                                                    <td>
                                                        <a href="https://{{$cpanel->domain}}:2083" target="_blank" class="btn btn-sm btn-primary">Cpanel</a>
                                                    </td>
                                                    <td>
                                                        <a href="{{route('sql.list', ['cpanel_id'=>$cpanel->id])}}" class="btn btn-sm btn-primary">Add Database</a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="addCpanelModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Cpanel</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Select Whm</label>
                                <select name="cpanel_whm" id="cpanel_whm" class="form-control">
                                    @if (!$whms->isEmpty())
                                        @foreach ($whms as $whm)
                                            <option value="{{$whm->id}}">{{$whm->ip}} ({{ucfirst($whm->whm_type)}})</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Select Cpanel Type</label>
                                <select name="project" id="type" class="form-control">
                                    <option value="ecommerce">Ecommerce</option>
                                    <option value="personal">Personal</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12 mt-3">
                            <div class="form-group">
                                <label for="">Account username</label>
                                <input type="text" name="cpanel_user" id="cpanel_user" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12 mt-3">
                            <div class="form-group">
                                <label for="">Account Password</label>
                                <input type="password" name="cpanel_password" id="cpanel_password" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12 mt-3">
                            <div class="form-group">
                                <label for="">Cpanel Domain</label>
                                <input type="text" name="domain" id="cpanel_domain" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12 mt-3">
                            <div class="form-group">
                                <label for="">Package</label>
                                <select name="cpanel_package" id="cpanel_package" class="form-control">
                                    <option value="default">Default</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="text-align: right">
                    <button class="btn btn-md btn-primary" id="addCpanelBtn">Add Cpanel</button>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();


        });
    </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        $("#addCpanelAccount").on('click', function() {
            $("#addCpanelModal").modal('show');
        });
    </script>
    <script>
        $("#addCpanelBtn").on('click', function(){

            var cpanel_whm = $("#cpanel_whm").val();
            var cpanelUser = $("#cpanel_user").val();
            var cpanelPassword = $("#cpanel_password").val();
            var cpanelDomain = $("#cpanel_domain").val();
            var cpanelPackage =$("#cpanel_package").val();
            var cpanelType = $("#type").val();
            
            if(!cpanel_whm)
            {
                error("Please select whm");
                return;   
            }
            if(!cpanelUser)
            {
                error("Please enter cpanel user");
                return;
            }
            if(!cpanelPassword)
            {
                error("Please enter cpanel password");
                return;
            }
            if(!cpanelPackage)
            {
                error("Please select your package");
                return;
            }

            var data = {whm:cpanel_whm, user:cpanelUser, password:cpanelPassword, domain:cpanelDomain, package:cpanelPackage, _token:"{{csrf_token()}}", type:cpanelType};
            var url = "{{route('cpanel.add')}}";
            $.post(url, data, function(data){
                if(!data.result)
                {
                    var msg = data.msg;
                    error(msg);
                    return;
                }

                Swal.fire({
                    title:"Cpanel Created",
                    text:"Cpanel Created Successfully",
                    icon:"success"
                }).then(function(){
                    location.reload();
                })
                

            });


        });


        function error(msg)
        {
            Swal.fire({
                title:"Error",
                text:msg,
                icon:"error"
            })
        }

    </script>
    <script>
        $(document).on('click', '.disconnect_cpanel', function () {
            var id = $(this).attr('data-id');
            var url = "{{route('cpanel.disconnect')}}";

            Swal.fire({
                title: 'Are you sure?',
                text: "Do you really want to disconnect this cPanel account?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, disconnect it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.post(url, { _token: "{{csrf_token()}}", id: id }, function (response) {
                      
                        if (response.result) {
                            Swal.fire(
                                'Disconnected!',
                                'The cPanel account has been disconnected.',
                                'success'
                            ).then(function(){
                                location.reload();
                            });
                        } else {
                            Swal.fire(
                                'Failed!',
                                response.msg || 'Failed to disconnect the cPanel account.',
                                'error'
                            );
                        }
                    }).fail(function () {
                        // Handle any AJAX errors
                        Swal.fire(
                            'Error!',
                            'An error occurred while processing your request.',
                            'error'
                        );
                    });
                }
            });
        });

    </script>
    <script>
        $(document).on('click', '.connect_cpanel', function(){

            var id = $(this).attr('data-id');
            var data = {_token:"{{csrf_token()}}", id:id};
            var url = "{{route('cpanel.connect')}}";
            $.post(url, data, function(data){
                if(!data.result)
                {
                    error(data.msg);
                    return;   
                }

                Swal.fire({
                    title:"Cpanel Connected",
                    text:"Cpanel Connected Successfully",
                    icon:"success"
                }).then(function(){
                    location.reload();
                })

            }).fail(function(){
                error("Some error occured");
            })

        });
    </script>
@endsection
