@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Ecommerce Subscriptions') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="">
                    <i class="flaticon-home"></i>
                </a>
            </li>

        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Ecommerce Subscriptions') }}</div>
                        </div>
                    
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        <th>User</th>
                                        <th>Package</th>
                                        <th>Expiry Date</th>
                                        <th>Status</th>
                                    </thead>
                                    <tbody>
                                            @if ($subscriptions->isNotEmpty())
                                                @foreach ($subscriptions as $subscription)
                                                    <tr>
                                                        <td>
                                                            {{$subscription->user->email}}
                                                        </td>
                                                        <td>
                                                            {{$subscription->package->name}}
                                                        </td>
                                                        <td>
                                                            {{date('d F Y', strtotime($subscription->expires_on)) }}
                                                        </td>
                                                        <td>
                                                            @if ($subscription->status == 'cancelled')
                                                                <span class="badge bg-danger text-white">
                                                                    {{ucfirst($subscription->status)}}
                                                                </span>
                                                            @else
                                                                <span class="badge bg-primary text-white">
                                                                    {{ucfirst($subscription->status)}}
                                                                </span>
                                                            @endif
                                                            
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>

    <div id="errorbox"
        style="text-shadow: 1px 1px #999;border-radius:10px;position:fixed;top:80px;right:10px;width:300px;background-color:red;padding:20px; opacity: 0.8;color:#FFF;display:none;">
    </div>


@endsection
