@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('FTP Accounts') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('FTP Account List') }}</div>
                        </div>
                        <div class="col-md-8" style="text-align: right">
                            <button class="btn btn-md btn-primary" id="addFbAccountBtn">Add Account</button>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        <th>Cpanel</th>
                                        <th>Ftp Account</th>
                                      
                                        <th>Action</th>
                                    </thead>
                                    <tbody>
                                        @if (!$ftps->isEmpty())
                                          @foreach ($ftps as $ftp)
                                                <tr>
                                                <td>
                                                    {{$ftp->cpanel->domain}}
                                                </td>
                                                <td>
                                                    {{$ftp->ftp_username.'@'.$ftp->cpanel->domain}} 
                                                </td>
                                                <td>
                                                    <button class="btn btn-sm btn-danger remove_ftp" data-id="{{$ftp->id}}">Remove</button>
                                                </td>
                                            </tr>
                                          @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="ftpModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Ftp Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Cpanel</label>
                                <select name="ftp_cpanel" id="ftp_cpanel" class="form-control">
                                    <option value="0">Select Cpanel</option>
                                    @foreach ($cpanels as $cpanel)
                                        <option value="{{$cpanel->id}}">
                                            {{$cpanel->user}} ({{$cpanel->domain}})
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Username</label>
                                <input type="text" name="username" id="ftpUsername" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Password</label>
                                <input type="text" name="ftp_password" id="ftpPassword" class="form-control">
                            </div>
                        </div>
                        
                    </div>
                </div>
                <div class="modal-footer" style="text-align: right">
                    <button class="btn btn-md btn-primary" id="addFtpBtn">Add Ftp</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();


        });
    </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        $("#addFbAccountBtn").on('click', function() {
            $("#ftpModal").modal('show');
        });
    </script>
    <script>
        $(document).on('click', '.assign_project', function(){
            var id = $(this).attr('data-id');
            $("#ftp_id").val(id);
            $("#ftpAssignProject").modal('show')
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#addFtpBtn').on('click', function() {
                let host = $('#ftp_cpanel').val().trim();
                let ftpUsername = $('#ftpUsername').val().trim();
                let ftpPassword = $('#ftpPassword').val().trim();

                if(!host || host == "0")
                {
                    error("Please select host");
                    return;   
                }

                if(!ftpUsername)
                {
                    error("Please enter username");
                    return;
                }
                if(!ftpPassword)
                {
                    error("Please enter password");
                    return;
                }

                var data = {cpanel:host, username:ftpUsername, password:ftpPassword, _token:"{{csrf_token()}}"};
                var url = "{{route('ftps.add')}}";
                $.post(url, data, function(data){
                    console.log(data);
                    if(!data.result)
                    {
                        error(data.msg);
                        return;   
                    }

                    Swal.fire({
                        title:"Ftp Created",
                        text:"Ftp Created Successfully",
                        icon:"success"
                    }).then(function(){
                        location.reload();
                    })

                    return;

                });

                
            });

            function error(msg)
            {
                Swal.fire({
                    title:"Error",
                    text:msg,
                    icon:"error"
                })
            }

        });
    </script>
    <script>
        $(document).on('click', '.remove_ftp', function() {
            var id = $(this).attr('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: 'You are about to remove this FTP credential!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, remove it!',
                cancelButtonText: 'No, keep it',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    var url = '<?=url('admin/ftp/remove'); ?>';
                    var data = {id:id, _token:'<?=csrf_token(); ?>'};
                    $.post(url, data, function(data){
                        if(data.result)
                        {
                            Swal.fire({
                                title:"Deleted Successfully",
                                text:"Ftp Account Deleted Successfully",
                                icon:"success"
                            }).then(function(){
                                location.reload();
                            })
                        }
                    })
                }
            })
        });
    </script>
    <script>
        $("#assign_project").on('click', function(){
            var ftpId = $("#ftp_id").val();
            var project = $("#project").find(':selected').val();
            var data = {id:ftpId, _token:'<?=csrf_token(); ?>', project:project};
            var url = '<?=url('admin/ftp/assign'); ?>';
            $.post(url, data, function(data){
                Swal.fire({
                    title:"Ftp Assigned",
                    text:"Ftp Assigned To project successfully",
                    icon:"success"
                }).then(function(){
                    location.reload()
                })
            })
        });
    </script>
@endsection
