@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/dropzone.min.css">
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="card-title d-inline-block">{{ __('Categories') }}</div>
                        </div>
                        <div class="col-md-4" style="text-align:right;">
                            <button class="btn btn-md btn-primary" id="imagesSections">Add Image Section</button>
                        </div>

                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="">Select Category</label>
                                <select class="form-control" name=" category_" id="category_web">
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->slug }}">
                                            {{ $category->category }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="">Image Category</label>
                                <select name="image_category" id="image_category" class="form-control">
                                    @foreach ($image_categories as $imgCats)
                                        <option value="{{ $imgCats->slug }}">
                                            {{ $imgCats->section }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-md btn-warning" id="editCat" style="margin-top: 35px;width:100%;">
                                <i class="fa fa-pencil"></i>
                            </button>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-md btn-danger" id="removeCat" style="margin-top: 35px;width:100%;">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-md btn-primary" id="showImages" style="margin-top:35px;">Show
                                Images</button>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <form action="{{ route('categories.image.upload') }}" method="POST"
                                enctype="multipart/form-data" class="dropzone" id="image-upload" style="width:100%;">
                                @csrf
                            </form>
                        </div>
                        <div class="col-md-12" style="text-align: right;">
                            <button class="btn btn-md btn-primary" id="uploadBtn" style="margin-top:5px;">Upload
                                Images</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row hide mb-3" id="bulkdeleterow">
        <div class="col-md-12" style="text-align: right">
            <button class="btn btn-md btn-danger" id="moveBulkImages">Bulk Move</button>
            <button class="btn btn-md btn-danger" id="deleteBulk">Bulk Delete</button>
        </div>
    </div>
    <div id="images" class="row">

    </div>

    <div class="modal fade" id="imagesSectionModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Images Section</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Enter Section</label>
                                <input type="text" name="img_section" id="img_section" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary" id="addimgSection">Add Section</button>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="moveImageSection" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Images Section</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Select New Section</label>
                                <select name="img_new_section" id="img_new_section" class="form-control">
                                    @foreach ($image_categories as $imgCats)
                                        <option value="{{ $imgCats->slug }}">
                                            {{ $imgCats->section }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary" id="changeImgSection">Change Images Section</button>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="editSectionModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Images Section</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Enter Section</label>
                                <input type="text" name="img_section" id="u_img_section" class="form-control">
                            </div>
                            <input type="hidden" name="" id="u_section_id">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary" id="updateSectionName">Update Section</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/dropzone.min.js"></script>

    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();


        });
    </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        Dropzone.options.imageUpload = {
            autoProcessQueue: false,
            acceptedFiles: "image/*",
            parallelUploads: 999,
            init: function() {
                var myDropzone = this;
                var btn = $("#uploadBtn");
                var btn_html = btn.html();
                document.getElementById("uploadBtn").addEventListener("click", function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    btn.html("<i class='fa fa-spinner fa-spin'></i>");
                    if (myDropzone.getQueuedFiles().length > 0) {
                        myDropzone.processQueue();
                    } else {
                        alert("No files to upload!");
                    }
                });


                myDropzone.on("addedfile", function(file) {
                    var removeButton = Dropzone.createElement(
                        '<button class="btn btn-danger btn-sm remove-btn" <button class="btn btn-danger btn-sm remove-btn" style="border-radius: 0px;position: absolute;top: 0px;z-index: 99999 !important;!i;!;float: right;"><i class="fa fa-trash"></i></button>><i class="fa fa-trash"></i></button>'
                        );
                    removeButton.addEventListener("click", function(e) {
                        e.preventDefault();
                        e.stopPropagation();

                        myDropzone.removeFile(file);
                    });

                    // Append the remove button to the file preview
                    file.previewElement.appendChild(removeButton);
                });

                this.on("complete", function(file) {
                    var allFilesUploaded = this.getAcceptedFiles().length === this.getFilesWithStatus(
                        Dropzone.SUCCESS).length;

                    if (allFilesUploaded) {
                        Swal.fire('Upload Complete!', 'All files were uploaded successfully.', 'success');
                        this.removeAllFiles();
                        btn.html(btn_html);

                    }
                });

                myDropzone.on("sending", function(file, xhr, formData) {
                    var webCategory = $("#category_web").find(':selected').val();
                    var imageCategory = $("#image_category").find(':selected').val();
                    formData.append('web', webCategory);
                    formData.append('image_category', imageCategory);
                });

                myDropzone.on("success", function(file, response) {
                    console.log("Upload successful:", response);
                });

                myDropzone.on("error", function(file, response) {
                    console.error("Upload failed:", response);
                    btn.html(btn_html);
                });
            }
        };
    </script>
    <script>
        $("#showImages").on('click', function() {
            $("#bulkdeleterow").addClass('hide');
            var webCategory = $("#category_web").find(':selected').val();
            var imageCategory = $("#image_category").find(':selected').val();
            var data = {
                _token: '<?= csrf_token() ?>',
                category: webCategory,
                web_category: imageCategory
            };
            var url = '<?= url('get-stock-images') ?>';

            $.post(url, data, function(data) {
                $("#images").html("");
                if (data.length <= 0) {
                    Swal.fire({
                        title: "Error",
                        text: "No Image Found In This Section",
                        icon: "error"
                    });
                    return;
                }
                $("#bulkdeleterow").removeClass('hide');
                data.forEach(image => {
                    $("#images").append(
                        '<div class="col-md-3">' +
                        '<div class="card">' +
                        '<div class="card-body">' +
                        '<input type="checkbox" value="' + image +
                        '" class="form-checkbox delete_checkbox" />' +
                        '<img class="lazyload" data-src="' + image +
                        '" style="width:100%;height:150px;object-fit:cover;" />' +
                        '</div>' +
                        '<div class="card-footer">' +
                        '<button class="btn btn-md btn-danger remove__image" data-url="' +
                        image + '" style="width:100%;">Remove Image</button>' +
                        '</div>' +
                        '</div>' +
                        '</div>'
                    );
                });
                lazyLoadImages();

                $('html, body').animate({
                    scrollTop: $("#images").offset().top
                }, 800);
            });
        });
        function lazyLoadImages() {
            const lazyImages = document.querySelectorAll('.lazyload');

            if ("IntersectionObserver" in window) {
                const imageObserver = new IntersectionObserver((entries, observer) => {
                    entries.forEach(entry => {
                        if (entry.isIntersecting) {
                            const img = entry.target;
                            img.src = img.dataset.src; // Set the actual `src`
                            img.classList.remove('lazyload');
                            observer.unobserve(img);
                        }
                    });
                });

                lazyImages.forEach(image => {
                    imageObserver.observe(image);
                });
            } else {
                lazyImages.forEach(img => {
                    img.src = img.dataset.src;
                    img.classList.remove('lazyload');
                });
            }
        }
    </script>
    <script>
        $(document).on('click', '.remove__image', function() {
            var url = $(this).attr('data-url');
            var removeUrl = '<?= url('remove-image-url') ?>';
            var img = $(this);
            $.post(removeUrl, {
                _token: '<?= csrf_token() ?>',
                url: url
            }, function(data) {
                img.parent().parent().parent().remove();
            });
        });
    </script>
    <script>
        $("#imagesSections").on('click', function() {
            $("#imagesSectionModal").modal('show');
        });
        $("#addimgSection").on('click', function() {
            var section = $("#img_section").val();
            var url = '<?= url('image/section/add') ?>';
            var data = {
                _token: '<?= csrf_token() ?>',
                section: section
            };
            $.post(url, data, function(data) {
                location.reload();
            });
        });
    </script>
    <script>
        $("#editCat").on('click', function() {
            var selectedCategory = $("#image_category").val();
            var text = $("#image_category").find(':selected').text();
            text = text.trim();
            $("#editSectionModal").modal('show');
            $("#u_img_section").val(text);
            $("#u_section_id").val(selectedCategory);

        });

        $("#updateSectionName").on('click', function() {
            var section = $("#u_img_section").val();
            var slug = $("#u_section_id").val();
            var data = {
                section: section,
                slug: slug,
                _token: '<?= csrf_token() ?>'
            };
            var url = '<?= url('image/section/update') ?>';
            $.post(url, data, function(data) {
                location.reload();
            });
        });
    </script>
    <script>
        $("#removeCat").on('click', function() {
            var selectedCategory = $("#image_category").val();
            var text = $("#image_category").find(':selected').text();
            text = text.trim();
            Swal.fire({
                title: "Are you sure?",
                text: "Do you really want to delete " + text + "? This action cannot be undone.",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "Cancel"
            }).then((result) => {
                if (result.isConfirmed) {
                    var data = {
                        _token: '<?= csrf_token() ?>',
                        slug: selectedCategory
                    };
                    var url = '<?= url('image/section/delete') ?>';
                    $.post(url, data, function(data) {
                        location.reload();
                    })
                }
            });
        });
    </script>
    <script>
        let movedImages = [];
        $("#moveBulkImages").on('click', function() {
            let checkedCheckboxes = $(".delete_checkbox:checked");
            let urls = [];
            checkedCheckboxes.each(function() {
                urls.push($(this).val());
            });

            if (urls.length <= 0) {
                return; // Exit if no checkboxes are checked
            }
            movedImages = urls;
            $("#moveImageSection").modal('show');

        });
        $("#changeImgSection").on('click', function() {
            var secX = $("#img_new_section").val();
            let requests = movedImages.map(url => {
                let removeUrl = '<?= url('change-image-section') ?>';
                let checkbox = $('.delete_checkbox[value="' + url + '"]');
                let imageDiv = checkbox.closest('.col-md-3');
                return $.post(removeUrl, {
                    _token: '<?= csrf_token() ?>',
                    url: url,
                    section: secX
                }).done(function(data) {
                    imageDiv.remove();
                    $("#moveImageSection").modal('hide');
                    movedImages = [];
                }).fail(function() {
                    console.error("Failed to delete image:", url);
                });
            });
            $.when(...requests).always(function() {
                btn.html(btn_html);
            });
        })
    </script>
    <script>
        $("#deleteBulk").on('click', function() {
            let checkedCheckboxes = $(".delete_checkbox:checked");
            let urls = [];
            checkedCheckboxes.each(function() {
                urls.push($(this).val());
            });

            if (urls.length <= 0) {
                return; // Exit if no checkboxes are checked
            }

            let btn = $(this);
            let btn_html = btn.html();
            btn.html("<i class='fa fa-spinner fa-spin'></i>");

            let requests = urls.map(url => {
                let removeUrl = '<?= url('remove-image-url') ?>';
                let checkbox = $('.delete_checkbox[value="' + url + '"]'); // Target checkbox by URL value
                let imageDiv = checkbox.closest('.col-md-3'); // Find the image's parent div

                return $.post(removeUrl, {
                    _token: '<?= csrf_token() ?>',
                    url: url
                }).done(function(data) {
                    imageDiv.remove();
                }).fail(function() {
                    console.error("Failed to delete image:", url);
                });
            });
            $.when(...requests).always(function() {
                btn.html(btn_html);
            });
        });
    </script>
@endsection
