@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        .svg_img_tag {
            height: 100px;
        }

        #appendShapes {
            height: 500px;
            overflow: scroll;
            overflow-x: hidden;
        }

        #backgroundOptions {
            height: 500px;
            overflow: scroll;
            overflow-x: hidden;
        }

        td {
            white-space: nowrap;
        }

        #templateOptions {
            min-height: 700px;
            border-radius: 5px;
        }

        #leftOptionEditor {
            width: 100%;
            list-style-type: none;
            text-align: center;
        }

        #leftOptionEditor li {
            list-style-type: none;
        }

        .options:hover {
            background-color: azure;
        }

        .options {
            padding-top: 20px;
        }

        #appendOptions .card {
            min-height: 400px;
            max-width: 350px;
        }

        #appendOptions {
            position: absolute;
            top: 140px;
            left: 170px;
            width: 350px;
        }

        #appendOptions .card {
            border-radius: 20px;
        }

        #addTextBtn {
            width: 100%;
        }

        .hide {
            display: none;
        }

        .closeOption {
            text-align: right;
            float: right;
            border-radius: 100px;
            width: 25px;
            height: 25px;
            text-align: center;
            background-color: transparent !important;
            color: black;
            margin-bottom: 10px;
        }

        #addHeading,
        #addSubHeading,
        #addParagraph {
            text-align: center;
            border: 1px solid #999;
            margin-top: 10px;
            padding-top: 10px;
            padding-bottom: 10px;
            cursor: pointer;
        }

        .svg_background {
            cursor: pointer;
        }

        .svg_background:hover {
            border: 1px solid #999;
        }
    </style>
    <link
        href="https://fonts.googleapis.com/css2?family=Roboto:wght@400&family=Open+Sans:wght@400&family=Lato:wght@400&display=swap"
        rel="stylesheet">
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Image Template') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="">{{ __('Image Template') }}</a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-2" style="text-align: center;">
            <div class="card" style="border-radius:20px;">
                <div class="card-body" id="templateOptions" style="border-radius:10px !important;">
                    <div class="row options" id="showtextoptions">
                        <div class="col-md-12">
                            <i class="fa fa-font" style="font-size:32px;"></i>
                            <p>Text</p>
                        </div>
                    </div>
                    <div class="row options" id="showImageOptions" style="cursor: pointer;">
                        <div class="col-md-12">
                            <i class="fa fa-image" style="font-size:32px;"></i>
                            <p>Image</p>
                        </div>
                    </div>
                    <div class="row options" id="showExpandedShapes" style="cursor: pointer;">
                        <div class="col-md-12">
                            <i class="fa fa-star" style="font-size:32px;"></i>
                            <p>Shapes</p>
                        </div>
                    </div>
                    <div class="row options" id="showBackgrounds" style="cursor: pointer;">
                        <div class="col-md-12">
                            <i class="fa fa-image" style="font-size:32px;"></i>
                            <p>Backgrounds</p>
                        </div>
                    </div>

                    <div class="row options" id="saveImage">
                        <div class="col-md-12">
                            <i class="fa fa-floppy-o" style="font-size:32px;"></i>
                            <p>Save</p>
                        </div>
                    </div>
                    <div class="row options" id="downloadImage">
                        <div class="col-md-12">
                            <i class="fa fa-download" style="font-size:32px;"></i>
                            <p>Download</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-10">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3" style="gap: 10px;">
                                <!-- Alignment Dropdown -->
                                <div class="form-group flex-grow-1">
                                    <label for="changeAlign" class="mr-2">Alignment</label>
                                    <select name="changeAlign" class="form-control" id="changeAlign" style="width: 100%;">
                                        <option value="">Select Align</option>
                                        <option value="center">Center</option>
                                        <option value="left">Left</option>
                                        <option value="right">Right</option>
                                    </select>
                                </div>

                                <div class="form-group flex-grow-1">
                                    <label for="font" class="mr-2">Font</label>
                                    <select name="fontStyle" class="form-control" id="fontStyle" style="width: 100%;">
                                        <option value="0">Select Font</option>
                                    </select>
                                </div>

                                <!-- Text Color Picker -->
                                <div class="form-group flex-grow-1">
                                    <label for="textColor" class="mr-2">Text Color</label>
                                    <input type="color" name="textColor" id="textColor" class="form-control"
                                        style="padding: 0;">
                                </div>

                                <!-- Background Color Picker -->
                                <div class="form-group flex-grow-1">
                                    <label for="bgColor" class="mr-2">Background Color</label>
                                    <input type="color" name="bgColor" id="bgColor" class="form-control"
                                        style="padding: 0;">
                                </div>

                                <!-- Remove Active Element Button -->
                                <div class="form-group flex-grow-1">
                                    <label class="mr-2 d-block">&nbsp;</label> <!-- Empty label for alignment -->
                                    <button class="btn btn-sm btn-danger w-100" id="removeActiveElement">
                                        <i class="fa fa-trash"></i> Remove
                                    </button>
                                </div>


                                <div class="form-group flex-grow-1">
                                     <label class="mr-2 d-block">&nbsp;</label> <!-- Empty label for alignment -->
                                    <button class="btn btn-sm btn-danger w-100" id="removeBackgroundFromImage">
                                        <i class="fa fa-trash"></i> Remove Background
                                    </button>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div id="canvas-container"
                                        style="width: 100%; height: 100%; overflow: hidden; position: relative;margin:0 auto;">
                                        <canvas id="canvas"
                                            style="width: 1080px; height: 1980px; transform: scale(1.0); transform-origin: top left;border:1px solid #ccc;"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12 hide" id="appendOptions">
            <div class="card hide" id="textOptionsCard">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <button class="closeOption">
                                <i class="fa fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <button class="btn btn-md btn-primary" id="addTextBtn">Add Text</button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <h1 id="addHeading">Add Heading</h1>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <h3 id="addSubHeading">Add Sub Heading</h3>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p id="addParagraph">Add Paragraph</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card hide" id="backgroundOptions">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <button class="closeOption">
                                <i class="fa fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <div class="row" id="appendBackgrounds">

                    </div>
                </div>
            </div>
            <div class="card hide" id="shapesOptions">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <button class="closeOption">
                                <i class="fa fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <div class="row" id="appendShapes">

                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="errorbox"
        style="text-shadow: 1px 1px #999;border-radius:10px;position:fixed;top:80px;right:10px;width:300px;background-color:red;padding:20px; opacity: 0.8;color:#FFF;display:none;">
    </div>


    <div class="modal fade" id="newTemplate" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create New Template</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Template Type</label>
                                <select name="template_type" id="template_type" class="form-control">
                                    <option value="0">Select Type</option>
                                    <option value="cgi">Cgi</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12 hide" id="cgiColumn">
                            <div class="form-group">
                                <label for="">Cgi Templates</label>
                                <select name="cgi_templates" id="cgi_templates" class="form-control">

                                </select>
                            </div>
                        </div>
                        <div class="col-md-12 hide" id="cgiTemplateOptions">
                            <div class="form-group">
                                <label for="">Cgi Images Type</label>
                                <select name="cgi_image_template" id="cgi_image_template" class="form-control">

                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <p style="text-align: center;">OR</p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Upload Image</label>
                                <input type="file" name="uploadMainImage" id="uploadMainImage" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Height</label>
                                <input type="text" name="height" id="canvasHeight" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Width</label>
                                <input type="text" name="width" id="canvasWidth" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="newTempBtn">Create</button>
                </div>
            </div>
        </div>
    </div>


    <input type="file" name="uploadImage" id="uploadImage" class="hide">
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fabric.js/5.2.4/fabric.min.js"></script>

    <script>
        $(document).ready(function() {


            const canvas = new fabric.Canvas('canvas');
            var jsCode = "{{$template->canvas_data}}";
            
            var canvasWidth = "{{$template->width}}";
            var canvasHeight = "{{$template->height}}";

            var templateId = "{{$template->id}}";

            updateCanvas(canvas, templateId);


           


            const fontsToLoad = [{
                    name: 'Roboto',
                    url: 'https://fonts.gstatic.com/s/roboto/v30/KFOmCnqEu92Fr1Mu4mxK.woff2'
                },
                {
                    name: 'Open Sans',
                    url: 'https://fonts.gstatic.com/s/opensans/v29/mem8YaGs126MiZpBA-UFVZ0e.ttf'
                },
                {
                    name: 'Lato',
                    url: 'https://fonts.gstatic.com/s/lato/v24/S6u_w4BMUTPHh6UVSwiPHA.ttf'
                }
            ];

            const fontSelect = $('#fontStyle');
            fontsToLoad.forEach(font => {
                fontSelect.append(`<option value="${font.name}">${font.name}</option>`);
            });

            const loadFonts = async () => {
                const fontPromises = fontsToLoad.map(font => {
                    const fontFace = new FontFace(font.name, `url(${font.url})`);
                    return fontFace.load().then(loadedFont => {
                        document.fonts.add(loadedFont);
                        console.log(`Font "${font.name}" loaded.`);
                    }).catch(error => console.error(`Failed to load font "${font.name}":`,
                        error));
                });

                await Promise.all(fontPromises);
                console.log('All fonts loaded successfully.');
            };
            loadFonts();


            let canvasCreated = false;
            $('#newTemplate').on('hidden.bs.modal', function() {
                var canvasHeight = $("#canvasHeight").val();
                var canvasWidth = $("#canvasWidth").val();
                if (!canvasCreated) {
                    $("#newTemplate").modal('show');
                }
            });

            $("#newTempBtn").on('click', function() {
                var canvasHeight = $("#canvasHeight").val();
                var canvasWidth = $("#canvasWidth").val();
                if (!canvasHeight) {
                    Swal.fire({
                        title: "Error",
                        text: "Please enter canvas height",
                        icon: "error"
                    })
                    return;
                }
                if (!canvasWidth) {
                    Swal.fire({
                        title: "Error",
                        text: "Please enter canvas width",
                        icon: "error"
                    })
                    return;
                }
                canvasCreated = true;
                $(".upper-canvas").css({
                    'width': canvasWidth,
                    'height': canvasHeight
                });
                canvas.setWidth(Number(canvasWidth));
                canvas.setHeight(Number(canvasHeight));
                canvas.renderAll(); // Rerender the canvas
                

                uploadImageInCanvas();

                $("#newTemplate").modal('hide');

            })

                

            function uploadImageInCanvas()
            {
                const file = $("#uploadMainImage")[0].files[0]; // Correct file access
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(f) {
                        const data = f.target.result;
                        // Load the image onto the canvas
                        fabric.Image.fromURL(data, function(img) {
                            img.scaleToWidth(canvas.getWidth()); // Scale image to fit canvas
                            img.scaleToHeight(canvas.getHeight());
                            canvas.add(img);
                            canvas.setActiveObject(img);
                            canvas.renderAll();
                            img.bringToFront();
                        });
                    };
                    reader.readAsDataURL(file);
                }
            }

           

            $("#removeBackgroundFromImage").on('click', function(){
                const activeObject = canvas.getActiveObject();
                console.log(activeObject);
                if (activeObject && activeObject.type === "image") {

                    const imageData = activeObject.toDataURL({
                        format: "png", // Use "jpeg" if needed
                        quality: 1.0
                    });
                    console.log("Sending image to server...");
                    var url = "{{route('admin.image_template.upload_image')}}";
                    $.ajax({
                        url: url, // Change this to your server-side script
                        type: "POST",
                        data: {
                            image: imageData,
                            _token:"{{csrf_token()}}"
                        },
                        success: function (response) {
                            if(response.result)
                            {
                                var image = response.image; 
                                replaceImageInCanvas(image);
                            }
                        },
                        error: function (xhr, status, error) {
                            console.error("Upload Failed: ", error);
                            alert("Error uploading image.");
                        }
                    });
                }
            });


           


            function replaceImageInCanvas(newImageUrl) {
                const activeObject = canvas.getActiveObject();

                if (activeObject && activeObject.type === "image") {
                    fabric.Image.fromURL(newImageUrl, function (img) {
                        img.set({
                            left: activeObject.left,
                            top: activeObject.top,
                            scaleX: activeObject.scaleX,
                            scaleY: activeObject.scaleY,
                            angle: activeObject.angle,
                            selectable: true,
                            type: "image" // Ensure the new object is still an image
                        });

                        // Remove the old image and add the new one
                        canvas.remove(activeObject);
                        canvas.add(img);
                        canvas.setActiveObject(img); // Keep the new image selected
                        canvas.renderAll();
                    });
                } else {
                    alert("Please select an image first!");
                }
            }


            $("#changeAlign").on('change', function() {
                var align = $(this).val();
                if (align) {
                    const activeObject = canvas.getActiveObject(); // Get the active object
                    if (activeObject && (activeObject.type === 'i-text' || activeObject.type === 'text')) {
                        // Update text alignment
                        activeObject.set('textAlign', align);
                        canvas.renderAll(); // Re-render the canvas to apply changes
                    }
                }
            });

            $("#textColor").on('change', function() {
                var selectedColor = $(this).val(); // Get the selected color
                const activeObject = canvas.getActiveObject(); // Get the active object

                if (!activeObject) {
                    alert("Please select an object to change its color.");
                    return;
                }

                // Check the type of the active object
                if (activeObject.type === 'text' || activeObject.type === 'i-text' || activeObject.type ===
                    'textbox') {
                    activeObject.set('fill', selectedColor); // Change text color
                } else if (activeObject.type === 'group') {
                    activeObject._objects.forEach(obj => {
                        if (obj.type === 'text' || obj.type === 'i-text' || obj.type ===
                            'textbox') {
                            obj.set('fill', selectedColor); // Change color for text in a group
                        }
                    });
                } else if (activeObject.type === 'path' || activeObject.type === 'rect' || activeObject
                    .type === 'circle') {
                    activeObject.set('fill', selectedColor); // Change fill color for other shapes
                }

                // Re-render the canvas
                canvas.renderAll();
            });


            $("#bgColor").on('change', function() {
                var bgColor = $(this).val(); // Get the selected background color
                const activeObject = canvas.getActiveObject(); // Get the active object

                if (activeObject && (activeObject.type === 'i-text' || activeObject.type === 'text')) {
                    activeObject.set('backgroundColor', bgColor); // Set the background color
                    canvas.renderAll(); // Re-render the canvas to apply the changes
                }
            });


            $("#removeActiveElement").on('click', function() {
                var activeElement = canvas.getActiveObject();
                if (activeElement) {
                    canvas.remove(activeElement);
                    canvas.discardActiveObject(); // Clear active selection
                    canvas.renderAll();
                }
            })

            $("#addParagraph").on('click', function() {
                const heading = new fabric.IText('This is paragraph', {
                    left: 50, // X-coordinate
                    top: 50, // Y-coordinate
                    fontSize: 14, // Larger font size for H1
                    fill: '#000', // Text color
                    fontFamily: 'Arial', // Font family
                    underline: false, // Optional underline
                });

                canvas.add(heading); // Add heading to the canvas
                canvas.setActiveObject(heading); // Set the heading as the active object
                heading.bringToFront(); // Bring the heading to the front
            });

            $("#addSubHeading").on('click', function() {
                const heading = new fabric.IText('This is sub heading', {
                    left: 50, // X-coordinate
                    top: 50, // Y-coordinate
                    fontSize: 24, // Larger font size for H1
                    fontWeight: 'bold', // Bold font weight for emphasis
                    fill: '#000', // Text color
                    fontFamily: 'Arial', // Font family
                    underline: false, // Optional underline
                });

                canvas.add(heading); // Add heading to the canvas
                canvas.setActiveObject(heading); // Set the heading as the active object
                heading.bringToFront(); // Bring the heading to the front
            });

            $("#addHeading").on('click', function() {
                const heading = new fabric.IText('This is an heading', {
                    left: 50, // X-coordinate
                    top: 50, // Y-coordinate
                    fontSize: 36, // Larger font size for H1
                    fontWeight: 'bold', // Bold font weight for emphasis
                    fill: '#000', // Text color
                    fontFamily: 'Arial', // Font family
                    underline: false, // Optional underline
                });

                canvas.add(heading); // Add heading to the canvas
                canvas.setActiveObject(heading); // Set the heading as the active object
                heading.bringToFront(); // Bring the heading to the front
            });



            $("#addTextBtn").on('click', function() {
                const text = new fabric.IText('This is a paragraph', {
                    left: 50,
                    top: 50,
                    fontSize: 24,
                    fill: '#000',
                    fontFamily: 'Arial'
                });

                canvas.add(text); // Add text to the canvas
                canvas.setActiveObject(text); // Set the text as the active object
                text.bringToFront();
            });

            $("#fontStyle").on('change', function() {
                var selectedFont = $(this).val();
                const activeObject = canvas.getActiveObject();
                if (activeObject && selectedFont) {
                    activeObject.set('fontFamily', selectedFont);
                    canvas.renderAll();
                }
            });


            $("#downloadImage").on('click', function() {


                const dataURL = canvas.toDataURL({
                    format: 'png', // Format: png, jpeg, etc.
                    quality: 1, // Image quality (0 to 1)
                });


                const link = document.createElement('a');
                link.href = dataURL;
                link.download = 'canvas-image.png'; // Name of the downloaded file
                link.click();


            });

            $("#saveImage").on('click', function() {
                const dataURL = canvas.toDataURL({
                    format: 'png', // 'png' or 'jpeg'
                    quality: 1, // Quality for JPEG (ignored for PNG)
                });

                const blob = dataURLToBlob(dataURL); // Convert Base64 to Blob

                const formData = new FormData();
                formData.append('canvasImage', blob, 'canvas-image.png'); // Append Blob as file
                formData.append('canvasData', JSON.stringify(canvas.toJSON())); // Append JSON
                formData.append('templateType', $("#template_type").val());
                formData.append('template', $("#cgi_templates").val());
                formData.append('image_template', $("#cgi_image_template").val());
                formData.append('width', $("#canvasWidth").val());
                formData.append('height', $("#canvasHeight").val());
                formData.append('_token', $('meta[name="csrf-token"]').attr('content')); // CSRF token\
                formData.append('template_id', "{{$template->id}}");


                $.ajax({
                    url: "{{ route('admin.cgi.updateCanvas') }}",
                    method: 'POST',
                    data: formData,
                    processData: false, // Prevent jQuery from processing the data
                    contentType: false, // Prevent jQuery from setting Content-Type
                    success: function(response) {
                        Swal.fire({
                            title: "Success",
                            text: response.message || "Canvas saved successfully!",
                            icon: "success",
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            title: "Error",
                            text: "Failed to save the canvas. Please try again.",
                            icon: "error",
                        });
                        console.error(xhr.responseText);
                    },
                });
            });



            function dataURLToBlob(dataURL) {
                // Decode the Base64 string
                const byteString = atob(dataURL.split(',')[1]); // Remove "data:image/png;base64,"
                const mimeString = dataURL.split(',')[0].split(':')[1].split(';')[0]; // Extract MIME type

                // Create an ArrayBuffer and view
                const arrayBuffer = new ArrayBuffer(byteString.length);
                const uint8Array = new Uint8Array(arrayBuffer);

                // Assign byteString characters to the Uint8Array
                for (let i = 0; i < byteString.length; i++) {
                    uint8Array[i] = byteString.charCodeAt(i);
                }

                // Create and return the Blob
                return new Blob([arrayBuffer], {
                    type: mimeString
                });
            }


            $("#showImageOptions").on('click', function() {
                $("#uploadImage").click();
            });

            // Handle image upload and display on the canvas
            $("#uploadImage").on('change', function(e) {
                const file = e.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(f) {
                        const data = f.target.result;
                        // Load the image onto the canvas
                        fabric.Image.fromURL(data, function(img) {
                            img.scaleToWidth(canvas.getWidth() /
                                2); // Scale image to fit canvas
                            img.scaleToHeight(canvas.getHeight() / 2);
                            canvas.add(img);
                            canvas.renderAll();
                            img.bringToFront();
                        });
                    };
                    reader.readAsDataURL(file);
                }
            });

            $(document).on('click', '.svg_shapes', function() {
                var svgUrl = $(this).attr('src');
                fabric.loadSVGFromURL(svgUrl, function(objects, options) {
                    const svgGroup = fabric.util.groupSVGElements(objects,
                        options); // Group SVG elements
                    svgGroup.scaleToWidth(100); // Scale the SVG (optional)
                    svgGroup.scaleToHeight(100); // Scale the SVG (optional)
                    svgGroup.set({
                        left: 50, // X-coordinate
                        top: 50, // Y-coordinate
                    });
                    canvas.add(svgGroup); // Add the SVG group to the canvas
                    canvas.renderAll(); // Render the canvas
                });
            });

            $(document).on('click', '.svg_background', function() {
                var url = $(this).attr('src');
                $("#appendOptions").addClass('hide');
                fabric.Image.fromURL(url, function(img) {
                    // Calculate scale to cover the canvas
                    const scaleX = canvas.width / img.width;
                    const scaleY = canvas.height / img.height;
                    const scale = Math.max(scaleX, scaleY);

                    canvas.setBackgroundImage(img, canvas.renderAll.bind(canvas), {
                        originX: 'center', // Center horizontally
                        originY: 'center', // Center vertically
                        left: canvas.width / 2, // Center horizontally
                        top: canvas.height / 2, // Center vertically
                        scaleX: scale, // Apply uniform scaling
                        scaleY: scale // Apply uniform scaling
                    });
                });


            });


            let copiedObject = null; // To store the copied object

            // Listen for keyboard events
            document.addEventListener('keydown', function(event) {
                if ((event.ctrlKey || event.metaKey) && event.key === 'c') {
                    // Handle Ctrl+C or Cmd+C (Copy)
                    const activeObject = canvas.getActiveObject();
                    if (activeObject) {
                        activeObject.clone(function(cloned) {
                            copiedObject = cloned; // Save the cloned object
                            console.log('Object copied');
                        });
                    }
                }

                if ((event.ctrlKey || event.metaKey) && event.key === 'v') {
                    // Handle Ctrl+V or Cmd+V (Paste)
                    if (copiedObject) {
                        copiedObject.clone(function(clonedObj) {
                            // Offset the position for the pasted object
                            clonedObj.set({
                                left: clonedObj.left + 10,
                                top: clonedObj.top + 10,
                                evented: true, // Make the new object selectable
                            });

                            canvas.add(clonedObj); // Add the cloned object to the canvas
                            canvas.setActiveObject(clonedObj); // Set the cloned object as active
                            canvas.renderAll(); // Re-render the canvas
                            console.log('Object pasted');
                        });
                    }
                }
            });




        });
    </script>


    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        $("#showtextoptions").on('click', function() {
            $("#appendOptions").removeClass('hide');
            showOptions("textOptionsCard");
        });
    </script>
    <script>
        $(".closeOption").on('click', function() {
            $("#appendOptions").addClass('hide');

        });
    </script>
    <script>
        $("#showExpandedShapes").on('click', function() {
            $("#appendOptions").removeClass('hide');
            showOptions("shapesOptions");
            appendShapes();
        });

        function appendShapes() {
            var url = "{{ route('admin.getShapes') }}";
            $.get(url, {
                _token: "{{ csrf_token() }}"
            }, function(data) {
                if (data.length > 0) {
                    data.forEach(shape => {
                        // Clean up and format the SVG name
                        let svgName = shape.name.replaceAll('-', ' ').replace('.svg', '');

                        // Extract the SVG URL
                        let svgUrl = shape.url;

                        // Create the SVG display element
                        let svg = `
                            <div class='col-md-6 mb-3' style="height:150px;">
                                <img class="svg_shapes" src="${svgUrl}" alt="${svgName}" style="width:100%; max-height:200px; object-fit:contain;" />
                            </div>
                        `;

                        // Append the SVG to the container
                        $("#appendShapes").append(svg);
                    });
                } else {
                    // Display a message if no shapes are found
                    $("#appendShapes").html("<p class='text-center'>No shapes available.</p>");
                }
            });

        }


        $("#showBackgrounds").on('click', function() {
            $("#appendOptions").removeClass('hide');
            showOptions("backgroundOptions");
            appendBackgrounds();
        });

        function appendBackgrounds() {
            var url = "{{ route('admin.getBackgrounds') }}";
            $.get(url, {
                _token: "{{ csrf_token() }}"
            }, function(data) {
                if (data.length > 0) {
                    data.forEach(shape => {
                        // Clean up and format the SVG name
                        let svgName = shape.name.replaceAll('-', ' ').replace('.svg', '');

                        // Extract the SVG URL
                        let svgUrl = shape.url;
                        let svg = `
                            <div class='col-md-6 mb-3' style="height:150px;">
                                <img class="svg_background" src="${svgUrl}" alt="${svgName}" style="width:100%; max-height:200px; object-fit:contain;" />
                            </div>
                        `;

                        // Append the SVG to the container
                        $("#appendBackgrounds").append(svg);
                    });
                } else {
                    // Display a message if no shapes are found
                    $("#appendBackgrounds").html("<p class='text-center'>No shapes available.</p>");
                }
            });
        }

        function showOptions(id) {
            $("#textOptionsCard").hide();
            $("#shapesOptions").hide();
            $("#backgroundOptions").hide();
            $("#" + id).show();
        }

        $("#template_type").on('change', function() {
            var type = $(this).val();
            if (type == 'cgi') {
                appendCgiTemplates();
            }
        })

        function appendCgiTemplates() {
            $("#cgiColumn").removeClass('hide');
            $("#cgi_templates").html("");
            $("#cgi_templates").append('<option value="0">Select Template</option>');

            var getTemplates = "{{ route('cgi.all_templates') }}";
            $.get(getTemplates, {}, function(data) {
                if (data.result) {
                    var templates = data.templates;
                    if (templates.length > 0) {
                        templates.forEach(template => {
                            $("#cgi_templates").append('<option value="' + template.id + '">' + template
                                .template_name + '</option>');
                        });
                    }
                }
            })
        }

        $(document).on('change', '#cgi_templates', function() {
            var templateId = $(this).val();
            getTemplateInfo(templateId);
        });

        function getTemplateInfo(templateId) {
            $("#cgiTemplateOptions").removeClass('hide');
            var url = "{{ route('cgi.template_info') }}";
            $.get(url, {
                _token: "{{ csrf_token() }}",
                id: templateId
            }, function(data) {
                if (!data.result) {
                    Swal.fire({
                        title: "Error",
                        text: "Template not found",
                        icon: "error"
                    })
                    return;
                }

                var templateImages = JSON.parse(data.data.image_names);
                var templateHeights = JSON.parse(data.data.image_heights);
                var templateWidths = JSON.parse(data.data.image_widths);
                $("#cgi_image_template").html("<option value='0'>Select image template</option>");
                var c = 0;
                templateImages.forEach(imgTemplate => {
                    var height = templateHeights[c];
                    var width = templateWidths[c];
                    $("#cgi_image_template").append('<option data-width="' + width + '" data-height="' +
                        height + '">' + imgTemplate + '</option>');
                    c++;
                });

            })
        }

        $(document).on('change', '#cgi_image_template', function() {
            var height = $(this).find(':selected').attr('data-height');
            var width = $(this).find(':selected').attr('data-width');
            $("#canvasHeight").val(height);
            $("#canvasWidth").val(width);
        });


        $(document).ready(function() {
            $("#uploadMainImage").change(function(event) {
                var file = event.target.files[0];

                if (file) {
                    var img = new Image();
                    img.src = URL.createObjectURL(file);

                    img.onload = function() {
                        var width = this.width;
                        var height = this.height;
                        $("#canvasHeight").val(height);
                        $("#canvasWidth").val(width);
                        // Release object URL to prevent memory leak
                        URL.revokeObjectURL(img.src);
                    };
                }
            });
        });


        function updateCanvas(canvas, templateId)
        {
             var route = "{{route('cgi.getSavedJson')}}";
             $.post(route, {_token:"{{csrf_token()}}", id:templateId}, function(data){
                if(!data.result)
                {
                    var msg = data.msg;
                    if(!msg)
                    {
                        msg = "Some error occured";   
                    }
                    alert(msg);
                    return;
                }

                var json = data.template.canvas_data;
                if(json)
                {
                    canvas.setWidth(data.template.width);
                    canvas.setHeight(data.template.height);

                    canvas.loadFromJSON(json, function () {
                        canvas.renderAll(); // Render after loading
                    });
                }
            });
            
          
        }

    </script>
@endsection
