@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Database') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Database List') }}</div>
                        </div>
                        <div class="col-md-8" style="text-align: right">
                            <button class="btn btn-md btn-primary" id="addCpanelAccount">Add Database</button>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        <th>Cpanel</th>
                                        <th>Db</th>
                                        <th>User</th>
                                        <th>Password</th>
                                        <th>Action</th>
                                    </thead>
                                    <tbody>
                                        @if (!$dbs->isEmpty())
                                            @foreach ($dbs as $db)
                                                <tr>
                                                    <td>
                                                        {{$db->cpanel->domain}}
                                                    </td>
                                                    <td>
                                                        {{$db->db_name}}
                                                    </td>
                                                    <td>
                                                        {{$db->db_user}}
                                                    </td>
                                                    <td>
                                                        {{$db->db_password}}
                                                    </td>
                                                    <td>
                                                        
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="addCpanelModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Cpanel</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Database username</label>
                                <input type="text" name="database_username" id="database_username" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Database password</label>
                                <input type="text" name="database_password" id="database_password" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Database name</label>
                                <input type="text" name="database_password" id="database_name" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="text-align: right">
                    <button class="btn btn-md btn-primary" id="addDatabase">Add Database</button>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();


        });
    </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        $("#addCpanelAccount").on('click', function() {
            $("#addCpanelModal").modal('show');
        });
    </script>
    <script>
        
        $("#addDatabase").on('click', function(){

            var username = $("#database_username").val();
            var password = $("#database_password").val();
            var name = $("#database_name").val();
            if(!username)
            {
                error("Please enter database username");   
                return;
            }

            if(!password)
            {
                error("Please enter database password");   
                return;
            }

            if(!name)
            {
                error("Please enter database name");   
                return;
            }

            var cpanelId = "{{$cpanel_id}}";
            var data = {cpanelId:cpanelId, username:username, password:password, name:name, _token:"{{csrf_token()}}"};
            var url = "{{route('sql.add')}}";
            $.post(url, data, function(data){
                if(!data.result)
                {
                    var msg = "Some error occured";
                    if(data.msg)
                    {
                        msg = data.msg;   
                    }
                    error(msg)
                    return;   
                }
                Swal.fire({
                    title:"Database created",
                    icon:"success",
                    text:"Database created successfully"
                }).then(function(){
                    location.reload();
                })
            }); 



        });

        function error(msg)
        {
            Swal.fire({
                title:"Error",
                text:msg,
                icon:"error"
            })
        }

    </script>
  
@endsection
