@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Subscriptions') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="">
                    <i class="flaticon-home"></i>
                </a>
            </li>

        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Subscriptions') }}</div>
                        </div>
                        <div class="col-md-8" style="text-align: right">
                            <button class="btn btn-md btn-primary" id="addNew">Add New</button>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        <th>Name</th>
                                        <th>Price</th>
                                        <th>Professional Emails</th>
                                        <th>Action</th>
                                    </thead>
                                    <tbody>
                                        @foreach ($subscriptions as $subscription)
                                            <tr>
                                                <td>
                                                    {{ $subscription->name }}
                                                </td>
                                                <td>
                                                    {{ $subscription->price }}
                                                </td>
                                                <td>
                                                    {{$subscription->emails}}
                                                </td>
                                                <td>
                                                    <button class="btn btn-sm btn-warning edit"
                                                        data-id="{{ $subscription->id }}"
                                                        data-emails="{{$subscription->emails}}"
                                                        data-projects="{{ $subscription->projects }}"
                                                        data-days="{{ $subscription->active_days }}"
                                                        data-price="{{ $subscription->price }}"
                                                        data-features='{!! $subscription->features !!}'
                                                        data-name="{{ $subscription->name }}">
                                                        Edit
                                                    </button>
                                                    <button class="btn btn-sm btn-danger delete"
                                                        data-id="{{ $subscription->id }}">
                                                        Delete
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>

    <div id="errorbox"
        style="text-shadow: 1px 1px #999;border-radius:10px;position:fixed;top:80px;right:10px;width:300px;background-color:red;padding:20px; opacity: 0.8;color:#FFF;display:none;">
    </div>


    <div class="modal fade" id="newSubscriptionModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Subscription</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Name</label>
                                <input type="text" name="name" id="name" class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="">Emails</label>
                                <input type="text" name="name" id="emails" class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="">Price ($)</label>
                                <input type="text" name="name" id="price" class="form-control">
                            </div>
                            <div class="form-group" style="display: none;">
                                <label for="">Active Days</label>
                                <input type="text" name="name" id="days" value="30" class="form-control">
                            </div>
                            <div class="form-group" style="display: none;">
                                <label for="">No. Of Projects</label>
                                <input type="text" name="name" id="projects" value="1" class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="">Features</label>
                                <div id="features-wrapper">
                                    <div class="input-group mb-2 feature-input">
                                        <input type="text" name="features[]" class="form-control"
                                            placeholder="Enter a feature">
                                        <button type="button" class="btn btn-danger btn-sm remove-feature">Remove</button>
                                    </div>
                                </div>
                                <button type="button" class="btn btn-sm btn-primary mt-2" id="add-feature">Add
                                    Feature</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="addNewBtn">Add</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update Subscription</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            
                            <div class="form-group">
                                <label for="">Name</label>
                                <input type="text" name="name" id="uname" class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="">Emails</label>
                                <input type="text" name="name" id="uemails" class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="">Price ($)</label>
                                <input type="text" name="name" id="uprice" class="form-control">
                            </div>
                            <div class="form-group" style="display: none">
                                <label for="">Active Days</label>
                                <input type="text" name="name" id="udays" class="form-control">
                            </div>
                            <div class="form-group" style="display: none;">
                                <label for="">No. Of Projects</label>
                                <input type="text" name="name" id="uprojects" class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="">Features</label>
                                <div id="ufeatures-wrapper">
                                    <!-- Dynamic feature inputs will be added here -->
                                </div>
                                <button type="button" class="btn btn-sm btn-primary mt-2" id="uadd-feature">Add
                                    Feature</button>
                            </div>
                        </div>
                    </div>
                </div>

                <input type="hidden" id="uid">

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="updatesubs">Update</button>
                </div>
            </div>
        </div>
    </div>

    <input type="hidden" name="domain" id="nsdomain">
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();

            // Loop over each row in the DataTable
            table.rows().every(function() {
                var row = this.node(); // Get the DOM node for the row
                var firstTd = $(row).find('td:first');
                var id = firstTd.attr('data-id');
                var domain = firstTd.attr('data-domain');
                var getDomainInfo = '<?= url('domains/info') ?>';
                var data = {
                    _token: '<?= csrf_token() ?>',
                    domain: domain
                };
                $.post(getDomainInfo, data, function(data) {

                    if (!data.result) {
                        $("#purchased_" + id).html(
                            '<span class="badge bg-danger text-white">Error</span>');
                        $("#expired_" + id).html(
                            '<span class="badge bg-danger text-white">Error</span>');
                        return;
                    }

                    $("#purchased_" + id).html(data.created);
                    $("#expired_" + id).html(data.expires);


                })

            });
        });
    </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        $("#addNew").on('click', function() {
            $("#newSubscriptionModal").modal('show');
        });
    </script>
    <script>
        $("#addNewBtn").on('click', function() {

            var name = $("#name").val();
            var price = $("#price").val();
            var days = $("#days").val();
            var projects = $("#projects").val();
            var emails = $("#emails").val();
            var features = [];
            $("input[name='features[]']").each(function() {
                var val = $(this).val().trim();
                if (val !== "") {
                    features.push(val);
                }
            });

            if (!name) {
                error("Please enter subscription name");
                return;
            }
            if (!price) {
                error("Please enter price of subscription");
                return;
            }
            if (!days) {
                error("Please enter active days for subscription");
                return;
            }

            if (!projects) {
                error("Please enter number of projects user can activate");
                return;
            }

            if(!emails)
            {
                error("Please enter number of emails");
                return;
            }

            var data = {
                _token: "<?= csrf_token() ?>",
                name: name,
                price: price,
                days: days,
                projects: projects,
                features: features,
                emails:emails
            };
            var url = "{{ route('personal.subscriptions.add') }}";
            $.post(url, data, function(data) {
                if (data.result) {
                    Swal.fire({
                        title: "Subscription added",
                        text: "Subscription added successfully",
                        icon: "success"
                    }).then(function() {
                        location.reload();
                    })
                } else {
                    Swal.fire({
                        title: "Error",
                        text: "Some error occured",
                        icon: "error"
                    })
                    return;
                }
            });

        });

        $(document).on('click', '.edit', function() {
            var id = $(this).data('id');
            var name = $(this).data('name');
            var price = $(this).data('price');
            var days = $(this).data('days');
            var projects = $(this).data('projects');
            var features = $(this).data('features') || [];
            var emails = $(this).attr('data-emails');


            $("#uid").val(id);
            $("#uname").val(name);
            $("#uprice").val(price);
            $("#udays").val(days);
            $("#uprojects").val(projects);
            $("#uemails").val(emails);

            $('#ufeatures-wrapper').empty();

            if (Array.isArray(features)) {
                features.forEach(function(feature) {
                    const featureInput = `
                <div class="input-group mb-2 ufeature-input">
                    <input type="text" name="ufeatures[]" class="form-control" value="${feature}" placeholder="Enter a feature">
                    <button type="button" class="btn btn-danger uremove-feature">Remove</button>
                </div>`;
                    $('#ufeatures-wrapper').append(featureInput);
                });
            }

            $("#updateModal").modal('show');
        });


        function error(msg) {
            Swal.fire({
                title: "Error",
                text: msg,
                icon: "error"
            })
        }

        $("#updatesubs").on('click', function() {
            var id = $("#uid").val();
            var name = $("#uname").val();
            var price = $("#uprice").val();
            var days = $("#udays").val();
            var projects = $("#uprojects").val();
            var emails = $("#uemails").val();

            var features = [];

            $("input[name='ufeatures[]']").each(function() {
                var val = $(this).val().trim();
                if (val) {
                    features.push(val);
                }
            });

            if (!name) {
                error("Please enter subscription name");
                return;
            }
            if (!price) {
                error("Please enter price of subscription");
                return;
            }
            if (!days) {
                error("Please enter active days for subscription");
                return;
            }

            if (!projects) {
                error("Please enter number of projects user can activate");
                return;
            }

            var data = {
                _token: "<?= csrf_token() ?>",
                id: id,
                name: name,
                price: price,
                days: days,
                projects: projects,
                features:features,
                emails:emails
            };
            var url = '<?= url('admin/subscriptions/edit') ?>'
            $.post(url, data, function(data) {
                if (data.result) {
                    Swal.fire({
                        title: "Subscription updated",
                        text: "Subscription updated successfully",
                        icon: "success"
                    }).then(function() {
                        location.reload();
                    })
                } else {
                    Swal.fire({
                        title: "Error",
                        text: "Some error occured",
                        icon: "error"
                    })
                    return;
                }
            });
        });
    </script>
    <script>
        $(document).on('click', '.delete', function() {
            var id = $(this).attr('data-id');
            Swal.fire({
                title: "Are you sure?",
                text: "Are you sure you want to delete this subscription?",
                icon: "warning",
                showCancelButton: true, // Show the Cancel button
                confirmButtonText: 'Yes', // Text for the confirm button
                cancelButtonText: 'No' // Text for the cancel button
            }).then((result) => {
                if (result.isConfirmed) {
                    var data = {
                        _token: "<?= csrf_token() ?>",
                        id: id
                    };
                    var url = '<?= url('admin/subscriptions/delete') ?>';
                    $.post(url, data, function(data) {
                        if (data.result) {
                            Swal.fire({
                                title: "Subscription deleted",
                                text: "Subscription deleted successfully",
                                icon: "success"
                            }).then(function() {
                                location.reload();
                            })
                        } else {
                            Swal.fire({
                                title: "Error",
                                text: "Some error occured",
                                icon: "error"
                            })
                            return;
                        }
                    });
                }
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#add-feature').on('click', function() {
                const featureInput = `
                    <div class="input-group mb-2 feature-input">
                        <input type="text" name="features[]" class="form-control" placeholder="Enter a feature">
                        <button type="button" class="btn btn-danger btn-sm remove-feature">Remove</button>
                    </div>`;
                $('#features-wrapper').append(featureInput);
            });

            // Delegate removal event
            $('#features-wrapper').on('click', '.remove-feature', function() {
                $(this).closest('.feature-input').remove();
            });
            // Add new feature input in update modal
            $('#uadd-feature').on('click', function() {
                const featureInput = `
                    <div class="input-group mb-2 ufeature-input">
                        <input type="text" name="ufeatures[]" class="form-control" placeholder="Enter a feature">
                        <button type="button" class="btn btn-danger uremove-feature">Remove</button>
                    </div>`;
                $('#ufeatures-wrapper').append(featureInput);
            });

            // Remove feature input in update modal
            $('#ufeatures-wrapper').on('click', '.uremove-feature', function() {
                $(this).closest('.ufeature-input').remove();
            });
        });
    </script>
@endsection
