@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Ecommerce Themes') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('Add Ecommerce Themes Colors') }}</div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="form-group">
                                <label for="">Themes</label>
                                <select name="themes" id="themes" class="form-control">
                                    <option value="0">Select Theme</option>
                                    @if (!empty($themes))
                                        @foreach ($themes as $theme)
                                            <option value="{{ $theme->theme }}">
                                                {{ $theme->theme }}
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">

                            <button class="btn btn-sm btn-primary" id="getColors"
                                style="margin-top:39px !important;width:100%;">Get Colors</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-3" id="colorCard" style="display:none;">
                <div class="card-body">
                    <div class="col-md-12" style="text-align: right;">
                        <button class="btn btn-sm btn-primary" id="addColors" style="margin-top:39px !important;">Add
                            Colors</button>
                    </div>
                    <div id="colorFields">

                    </div>
                    <div class="row mt-3">
                        <div class="col-md-12" style="text-align:right !important;">
                            <button class="btn btn-md btn-primary" id="updateColors">Update Colors</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $("#addColors").on('click', function() {
            var row = `
                <div class="row color-row">
                    <div class="col-md-5">
                        <div class="form-group">
                            <label>Primary Color</label>
                            <input class="form-control primaryColors" type="text" name="primaryColor[]" />
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <label>Secondary Color</label>
                            <input class="form-control secondaryColors" type="text" name="secondaryColor[]" />
                        </div>
                    </div>
                    <button type="button" class="btn btn-danger btn-md removeColors" style="margin-top:40px !important;height:40px !important;">Remove</button>
                </div>
            `;
            $("#colorFields").append(row);
        });

        // Remove button functionality
        $(document).on('click', '.removeColors', function() {
            $(this).closest('.color-row').remove();
        });
    </script>
    <script>
        $(document).on('click', '#getColors', function() {
            var theme = $("#themes").val();
            $("#colorCard").hide();
            $("#colorFields").html("");
            if (theme == '0') {
                Swal.fire({
                    title: "Error",
                    icon: "error",
                    text: "Please select theme"
                })
                return;
            }


            var data = {
                theme: theme,
                _token: "{{ csrf_token() }}"
            };
            var url = "{{ route('ecommerce.themes.getColors') }}";
            $.post(url, data, function(data) {
                console.log(data);
                $("#colorCard").show();
                if (!data.result) {
                    var msg = "Some error occured";
                    if (data.msg) {
                        msg = data.msg;
                        Swal.fire({
                            title: "Error",
                            text: msg,
                            icon: "error"
                        })
                    }
                    return;
                }
                var colorThemes = data.theme;
                if (colorThemes.length > 0) {
                    colorThemes.forEach(clr => {
                        var row = `
                            <div class="row color-row">
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label>Primary Color</label>
                                        <input class="form-control primaryColors" value="${clr.primary_color}" type="text" name="primaryColor[]" />
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label>Secondary Color</label>
                                        <input class="form-control secondaryColors" value="${clr.secondary_color}" type="text" name="secondaryColor[]" />
                                    </div>
                                </div>
                                <button type="button" class="btn btn-danger btn-md removeColors" style="margin-top:40px !important;height:40px !important;">Remove</button>
                            </div>
                        `;
                        $("#colorFields").append(row);
                    });
                }
            });

        });


        $(document).on('click', '#updateColors', function() {
            var primary = [];
            var secondary = [];
            $(".primaryColors").each(function() {
                primary.push($(this).val());
            });

            $(".secondaryColors").each(function() {
                secondary.push($(this).val());
            });
            var theme = $("#themes").val();
            var data = {
                theme: theme,
                secondary: secondary,
                primary: primary,
                _token: "{{ csrf_token() }}"
            };
            var url = "{{ route('ecommerce.themes.addColor') }}"
            $.post(url, data, function(data) {
                Swal.fire({
                    title: "Theme updated",
                    icon: "success",
                    text: "Theme updated successfully"
                })
            });
        });
    </script>
@endsection
